/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.auto.value.AutoValue;
import com.google.cloud.storage.contrib.nio.AutoValue_CloudStorageConfiguration;
import com.google.cloud.storage.contrib.nio.UnixPath;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.EOFException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

@AutoValue
public abstract class CloudStorageConfiguration {
    public static final CloudStorageConfiguration DEFAULT = CloudStorageConfiguration.builder().build();

    public abstract String workingDirectory();

    public abstract boolean permitEmptyPathComponents();

    public abstract boolean stripPrefixSlash();

    public abstract boolean usePseudoDirectories();

    public abstract int blockSize();

    public abstract int maxChannelReopens();

    @Nullable
    public abstract String userProject();

    public abstract boolean useUserProjectOnlyForRequesterPaysBuckets();

    public abstract ImmutableList<Integer> retryableHttpCodes();

    public abstract ImmutableList<Class<? extends Exception>> reopenableExceptions();

    public static Builder builder() {
        return new Builder();
    }

    static CloudStorageConfiguration fromMap(Map<String, ?> env) {
        return CloudStorageConfiguration.fromMap(CloudStorageConfiguration.builder(), env);
    }

    static CloudStorageConfiguration fromMap(CloudStorageConfiguration defaultValues, Map<String, ?> env) {
        return CloudStorageConfiguration.fromMap(new Builder(defaultValues), env);
    }

    private static CloudStorageConfiguration fromMap(Builder builder, Map<String, ?> env) {
        block24: for (Map.Entry<String, ?> entry : env.entrySet()) {
            switch (entry.getKey()) {
                case "workingDirectory": {
                    builder.workingDirectory((String)entry.getValue());
                    continue block24;
                }
                case "permitEmptyPathComponents": {
                    builder.permitEmptyPathComponents((Boolean)entry.getValue());
                    continue block24;
                }
                case "stripPrefixSlash": {
                    builder.stripPrefixSlash((Boolean)entry.getValue());
                    continue block24;
                }
                case "usePseudoDirectories": {
                    builder.usePseudoDirectories((Boolean)entry.getValue());
                    continue block24;
                }
                case "blockSize": {
                    builder.blockSize((Integer)entry.getValue());
                    continue block24;
                }
                case "maxChannelReopens": {
                    builder.maxChannelReopens((Integer)entry.getValue());
                    continue block24;
                }
                case "userProject": {
                    builder.userProject((String)entry.getValue());
                    continue block24;
                }
                case "useUserProjectOnlyForRequesterPaysBuckets": {
                    builder.autoDetectRequesterPays((Boolean)entry.getValue());
                    continue block24;
                }
                case "retryableHttpCodes": {
                    builder.retryableHttpCodes((ImmutableList)entry.getValue());
                    continue block24;
                }
                case "reopenableExceptions": {
                    builder.reopenableExceptions((ImmutableList)entry.getValue());
                    continue block24;
                }
            }
            throw new IllegalArgumentException(entry.getKey());
        }
        return builder.build();
    }

    CloudStorageConfiguration() {
    }

    public static final class Builder {
        private String workingDirectory = "/";
        private boolean permitEmptyPathComponents;
        private boolean stripPrefixSlash = true;
        private boolean usePseudoDirectories = true;
        private int blockSize = 0x200000;
        private int maxChannelReopens = 0;
        @Nullable
        private String userProject = null;
        private boolean useUserProjectOnlyForRequesterPaysBuckets = false;
        private ImmutableList<Integer> retryableHttpCodes = ImmutableList.of(Integer.valueOf(500), Integer.valueOf(502), Integer.valueOf(503));
        private ImmutableList<Class<? extends Exception>> reopenableExceptions = ImmutableList.of(SSLException.class, EOFException.class, SocketException.class, SocketTimeoutException.class);

        public Builder workingDirectory(String path) {
            Preconditions.checkNotNull(path);
            Preconditions.checkArgument(UnixPath.getPath(false, path).isAbsolute(), "not absolute: %s", (Object)path);
            this.workingDirectory = path;
            return this;
        }

        public Builder permitEmptyPathComponents(boolean value) {
            this.permitEmptyPathComponents = value;
            return this;
        }

        public Builder stripPrefixSlash(boolean value) {
            this.stripPrefixSlash = value;
            return this;
        }

        public Builder usePseudoDirectories(boolean value) {
            this.usePseudoDirectories = value;
            return this;
        }

        public Builder blockSize(int value) {
            this.blockSize = value;
            return this;
        }

        public Builder maxChannelReopens(int value) {
            this.maxChannelReopens = value;
            return this;
        }

        public Builder userProject(String value) {
            this.userProject = value;
            return this;
        }

        public Builder autoDetectRequesterPays(boolean value) {
            this.useUserProjectOnlyForRequesterPaysBuckets = value;
            return this;
        }

        public Builder retryableHttpCodes(ImmutableList<Integer> value) {
            this.retryableHttpCodes = value;
            return this;
        }

        public Builder reopenableExceptions(ImmutableList<Class<? extends Exception>> values) {
            this.reopenableExceptions = values;
            return this;
        }

        public CloudStorageConfiguration build() {
            return new AutoValue_CloudStorageConfiguration(this.workingDirectory, this.permitEmptyPathComponents, this.stripPrefixSlash, this.usePseudoDirectories, this.blockSize, this.maxChannelReopens, this.userProject, this.useUserProjectOnlyForRequesterPaysBuckets, this.retryableHttpCodes, this.reopenableExceptions);
        }

        Builder(CloudStorageConfiguration toModify) {
            this.workingDirectory = toModify.workingDirectory();
            this.permitEmptyPathComponents = toModify.permitEmptyPathComponents();
            this.stripPrefixSlash = toModify.stripPrefixSlash();
            this.usePseudoDirectories = toModify.usePseudoDirectories();
            this.blockSize = toModify.blockSize();
            this.maxChannelReopens = toModify.maxChannelReopens();
            this.userProject = toModify.userProject();
            this.useUserProjectOnlyForRequesterPaysBuckets = toModify.useUserProjectOnlyForRequesterPaysBuckets();
            this.retryableHttpCodes = toModify.retryableHttpCodes();
            this.reopenableExceptions = toModify.reopenableExceptions();
        }

        Builder() {
        }
    }
}

