/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStorageConfiguration;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystemProvider;
import com.google.cloud.storage.contrib.nio.CloudStoragePath;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class CloudStorageFileSystem
extends FileSystem {
    public static final String URI_SCHEME = "gs";
    public static final String GCS_VIEW = "gcs";
    public static final String BASIC_VIEW = "basic";
    public static final String POSIX_VIEW = "posix";
    public static final int BLOCK_SIZE_DEFAULT = 0x200000;
    public static final FileTime FILE_TIME_UNKNOWN = FileTime.fromMillis(0L);
    public static final Set<String> SUPPORTED_VIEWS = ImmutableSet.of("basic", "gcs", "posix");
    private final CloudStorageFileSystemProvider provider;
    private final String bucket;
    private final CloudStorageConfiguration config;
    private static final LoadingCache<ProviderCacheKey, CloudStorageFileSystemProvider> PROVIDER_CACHE_BY_CONFIG = CacheBuilder.newBuilder().build(new CacheLoader<ProviderCacheKey, CloudStorageFileSystemProvider>(){

        @Override
        public CloudStorageFileSystemProvider load(ProviderCacheKey key) {
            CloudStorageConfiguration config = key.cloudStorageConfiguration;
            StorageOptions storageOptions = key.storageOptions;
            String userProject = config.userProject();
            return storageOptions == null ? new CloudStorageFileSystemProvider(userProject) : new CloudStorageFileSystemProvider(userProject, storageOptions);
        }
    });
    private static CloudStorageConfiguration userSpecifiedDefault = CloudStorageConfiguration.DEFAULT;

    static void setDefaultCloudStorageConfiguration(CloudStorageConfiguration config) {
        userSpecifiedDefault = null == config ? CloudStorageConfiguration.DEFAULT : config;
    }

    static CloudStorageConfiguration getDefaultCloudStorageConfiguration() {
        return userSpecifiedDefault;
    }

    public static Page<Bucket> listBuckets(@Nullable String project, Storage.BucketListOption ... options) {
        CloudStorageFileSystemProvider provider = new CloudStorageFileSystemProvider(null, ((StorageOptions.Builder)StorageOptions.newBuilder().setProjectId(project)).build());
        return provider.listBuckets(options);
    }

    @CheckReturnValue
    public static CloudStorageFileSystem forBucket(String bucket) {
        return CloudStorageFileSystem.forBucket(bucket, userSpecifiedDefault);
    }

    @CheckReturnValue
    public static CloudStorageFileSystem forBucket(String bucket, CloudStorageConfiguration config) {
        return CloudStorageFileSystem.forBucket(bucket, config, null);
    }

    @CheckReturnValue
    public static CloudStorageFileSystem forBucket(String bucket, CloudStorageConfiguration config, @Nullable StorageOptions storageOptions) {
        CloudStorageFileSystemProvider result;
        Preconditions.checkArgument(!bucket.startsWith("gs:"), "Bucket name must not have schema: %s", (Object)bucket);
        Preconditions.checkNotNull(config);
        ProviderCacheKey providerCacheKey = new ProviderCacheKey(config, storageOptions);
        try {
            result = PROVIDER_CACHE_BY_CONFIG.get(providerCacheKey);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new IllegalStateException("Unable to resolve CloudStorageFileSystemProvider for the provided configuration", e);
        }
        return new CloudStorageFileSystem(result, bucket, config);
    }

    CloudStorageFileSystem(CloudStorageFileSystemProvider provider, String bucket, CloudStorageConfiguration config) {
        Preconditions.checkArgument(!bucket.isEmpty(), "bucket");
        this.bucket = bucket;
        if (config.useUserProjectOnlyForRequesterPaysBuckets()) {
            if (Strings.isNullOrEmpty(config.userProject())) {
                throw new IllegalArgumentException("If useUserProjectOnlyForRequesterPaysBuckets is set, then userProject must be set too.");
            }
            if (!provider.requesterPays(bucket)) {
                HashMap<String, String> disableUserProject = new HashMap<String, String>();
                disableUserProject.put("userProject", "");
                config = CloudStorageConfiguration.fromMap(config, disableUserProject);
                provider = provider.withNoUserProject();
            }
        }
        this.provider = provider;
        this.config = config;
    }

    @Override
    public CloudStorageFileSystemProvider provider() {
        return this.provider;
    }

    public String bucket() {
        return this.bucket;
    }

    public CloudStorageConfiguration config() {
        return this.config;
    }

    @Override
    public CloudStoragePath getPath(String first, String ... more) {
        Preconditions.checkArgument(!first.startsWith("gs:"), "Google Cloud Storage FileSystem.getPath() must not have schema and bucket name: %s", (Object)first);
        return CloudStoragePath.getPath(this, first, more);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return Character.toString('/');
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return ImmutableSet.of(CloudStoragePath.getPath(this, "/", new String[0]));
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return ImmutableSet.of();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return SUPPORTED_VIEWS;
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return FileSystems.getDefault().getPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CloudStorageFileSystem && Objects.equals(this.config, ((CloudStorageFileSystem)other).config) && Objects.equals(this.bucket, ((CloudStorageFileSystem)other).bucket);
    }

    public int hashCode() {
        return Objects.hash(this.bucket);
    }

    public String toString() {
        try {
            return new URI(URI_SCHEME, this.bucket, null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final class ProviderCacheKey {
        private final CloudStorageConfiguration cloudStorageConfiguration;
        @Nullable
        private final StorageOptions storageOptions;

        public ProviderCacheKey(CloudStorageConfiguration cloudStorageConfiguration, @Nullable StorageOptions storageOptions) {
            this.cloudStorageConfiguration = Objects.requireNonNull(cloudStorageConfiguration, "cloudStorageConfiguration must be non null");
            this.storageOptions = storageOptions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ProviderCacheKey)) {
                return false;
            }
            ProviderCacheKey that = (ProviderCacheKey)o;
            return this.cloudStorageConfiguration.equals(that.cloudStorageConfiguration) && Objects.equals(this.storageOptions, that.storageOptions);
        }

        public int hashCode() {
            return Objects.hash(this.cloudStorageConfiguration, this.storageOptions);
        }

        public String toString() {
            return "ConfigTuple{cloudStorageConfiguration=" + this.cloudStorageConfiguration + ", storageOptions=" + this.storageOptions + '}';
        }
    }
}

