/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.contrib.nio;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;

class CloudStorageReadFileChannel
extends FileChannel {
    private static final String READ_ONLY = "This FileChannel is read-only";
    private final SeekableByteChannel readChannel;

    CloudStorageReadFileChannel(SeekableByteChannel readChannel) {
        Preconditions.checkNotNull(readChannel);
        this.readChannel = readChannel;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.readChannel.read(dst);
    }

    @Override
    public synchronized long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long res = 0L;
        for (int i = offset; i < offset + length; ++i) {
            res += (long)this.readChannel.read(dsts[i]);
        }
        return res;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public long position() throws IOException {
        return this.readChannel.position();
    }

    @Override
    public FileChannel position(long newPosition) throws IOException {
        this.readChannel.position(newPosition);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this.readChannel.size();
    }

    @Override
    public FileChannel truncate(long size) throws IOException {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public void force(boolean metaData) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long transferTo(long transferFromPosition, long count, WritableByteChannel target) throws IOException {
        long res = 0L;
        long originalPosition = this.position();
        try {
            this.position(transferFromPosition);
            int blockSize = (int)Math.min(count, 1048575L);
            int bytesRead = 0;
            ByteBuffer buffer = ByteBuffer.allocate(blockSize);
            while (res < count && bytesRead >= 0) {
                buffer.position(0);
                bytesRead = this.read(buffer);
                if (bytesRead <= 0) continue;
                buffer.position(0);
                buffer.limit(bytesRead);
                target.write(buffer);
                res += (long)bytesRead;
            }
            long l = res;
            return l;
        }
        finally {
            this.position(originalPosition);
        }
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(ByteBuffer dst, long readFromPosition) throws IOException {
        long originalPosition = this.position();
        try {
            int res;
            this.position(readFromPosition);
            int n = res = this.readChannel.read(dst);
            return n;
        }
        finally {
            this.position(originalPosition);
        }
    }

    @Override
    public int write(ByteBuffer src, long position) throws IOException {
        throw new UnsupportedOperationException(READ_ONLY);
    }

    @Override
    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock lock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.readChannel.close();
    }
}

