/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class NativeLibraryLoader {
    private static final Log logger;
    private static final String USE_LIBRARY_PATH;
    private static final Set<String> loadedLibraries;
    private static final int MAX_PATH;

    private static boolean checkPath(String tempPath) {
        return tempPath.length() <= MAX_PATH;
    }

    private static boolean checkLibraryName(String libName) {
        if (libName == null || libName.length() == 0 || libName.length() > MAX_PATH) {
            logger.warn(" Unexpected library name");
            return false;
        }
        for (NATIVE_LIB libItem : NATIVE_LIB.values()) {
            if (!libName.matches(libItem.toString())) continue;
            return true;
        }
        logger.warn(String.format(" Unexpected library name %s", libName));
        return false;
    }

    public static synchronized boolean load(File tempDir, String libraryName) {
        if (!NativeLibraryLoader.checkLibraryName(libraryName)) {
            return false;
        }
        if (loadedLibraries.contains(libraryName)) {
            return true;
        }
        String systemLibraryName = System.mapLibraryName(libraryName);
        if (System.getenv(USE_LIBRARY_PATH) != null) {
            String javaLibraryPath = System.getProperty("java.library.path");
            try {
                logger.warn(String.format("OVERRIDE DEFAULT: Loading %s from %s", systemLibraryName, javaLibraryPath));
                logger.warn(String.format("LD_LIBRARY_PATH = %s", System.getenv("LD_LIBRARY_PATH")));
                System.loadLibrary(libraryName);
                return true;
            }
            catch (Error | Exception e) {
                logger.warn(String.format("OVERRIDE DEFAULT: Unable to load %s from %s", systemLibraryName, javaLibraryPath));
                return false;
            }
        }
        String resourcePath = "native/" + systemLibraryName;
        URL inputUrl = NativeLibraryLoader.class.getResource(resourcePath);
        if (inputUrl == null) {
            logger.warn(String.format("Unable to find native library: %s", resourcePath));
            return false;
        }
        logger.info(String.format("Loading %s from %s", systemLibraryName, inputUrl.toString()));
        try {
            File temp = File.createTempFile(FilenameUtils.getBaseName(resourcePath), "." + FilenameUtils.getExtension(resourcePath), tempDir);
            FileUtils.copyURLToFile(inputUrl, temp);
            temp.deleteOnExit();
            if (NativeLibraryLoader.checkPath(temp.getAbsolutePath())) {
                System.load(temp.getAbsolutePath());
                logger.debug(String.format("Extracting %s to %s", systemLibraryName, temp.getAbsolutePath()));
            } else {
                logger.warn(String.format("Unable to load %s to %s", systemLibraryName, temp.getAbsolutePath()));
            }
        }
        catch (Error | Exception e) {
            logger.warn(String.format("Unable to load %s from %s (%s)", systemLibraryName, resourcePath, e.getMessage()));
            return false;
        }
        loadedLibraries.add(libraryName);
        return true;
    }

    static {
        loadedLibraries = new HashSet<String>();
        logger = LogFactory.getLog(NativeLibraryLoader.class);
        USE_LIBRARY_PATH = "USE_LIBRARY_PATH";
        MAX_PATH = 4096;
    }

    private static enum NATIVE_LIB {
        gkl_compression,
        gkl_pairhmm,
        gkl_pairhmm_omp,
        gkl_smithwaterman,
        gkl_utils;

    }
}

