/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl.compression;

import com.intel.gkl.NativeLibraryLoader;
import java.io.File;
import java.util.zip.Deflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadinstitute.gatk.nativebindings.NativeLibrary;

public final class IntelDeflater
extends Deflater
implements NativeLibrary {
    private static final Log logger = LogFactory.getLog(IntelDeflater.class);
    private static final String NATIVE_LIBRARY_NAME = "gkl_compression";
    private static boolean initialized = false;
    private static final Object lock_class = new Object();
    private long lz_stream;
    private byte[] inputBuffer;
    private int inputBufferLength;
    private boolean endOfStream;
    private boolean finished;
    private int level;
    private int strategy;
    private boolean nowrap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean load(File tempDir) {
        Object object = lock_class;
        synchronized (object) {
            if (!NativeLibraryLoader.load(tempDir, NATIVE_LIBRARY_NAME)) {
                return false;
            }
            if (!initialized) {
                IntelDeflater.initNative();
                initialized = true;
            }
        }
        return true;
    }

    private static native void initNative();

    private native void resetNative(boolean var1);

    private native int deflateNative(byte[] var1, int var2);

    private native void endNative();

    public IntelDeflater(int level, boolean nowrap) {
        if ((level < 0 || level > 9) && level != -1) {
            throw new IllegalArgumentException("Illegal compression level");
        }
        if (!(level != 1 && level != 2 || nowrap)) {
            throw new IllegalArgumentException("Compression configuration requested not supported");
        }
        this.level = level;
        this.nowrap = nowrap;
        this.strategy = 0;
    }

    public IntelDeflater(int level) {
        this(level, true);
    }

    public IntelDeflater() {
        this(-1, true);
    }

    @Override
    public void reset() throws OutOfMemoryError, RuntimeException {
        try {
            this.resetNative(this.nowrap);
        }
        catch (OutOfMemoryError e) {
            logger.warn("Exception thrown from native Deflater resetNative function call " + e.getMessage());
            throw new OutOfMemoryError("Memory allocation failed");
        }
        catch (RuntimeException e) {
            logger.warn("Exception thrown from native Deflater resetNative function call " + e.getMessage());
            throw new RuntimeException("Deflate Initialization issue");
        }
        this.inputBuffer = null;
        this.inputBufferLength = 0;
        this.endOfStream = false;
        this.finished = false;
    }

    @Override
    public void setInput(byte[] b, int off, int len) {
        if (this.lz_stream == 0L) {
            this.reset();
        }
        if (b == null) {
            throw new NullPointerException("Input buffer is null");
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset value is less than zero");
        }
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException("Length value is less than zero");
        }
        if (off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException("Length value exceeds permissible range");
        }
        this.inputBuffer = b;
        this.inputBufferLength = len;
    }

    @Override
    public void finish() {
        this.endOfStream = true;
    }

    @Override
    public int deflate(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException("Output buffer is null");
        }
        if (off != 0) {
            throw new IllegalArgumentException("The only accepted offset value is 0");
        }
        if (len <= 0) {
            throw new ArrayIndexOutOfBoundsException("Length value is less or equal than zero");
        }
        if (this.inputBuffer == null || this.inputBufferLength == 0) {
            throw new NullPointerException("Input buffer is null");
        }
        int bytesWritten = this.deflateNative(b, len);
        return bytesWritten;
    }

    @Override
    public boolean finished() {
        return this.finished;
    }

    @Override
    public void end() {
        if (this.lz_stream != 0L) {
            this.endNative();
            this.lz_stream = 0L;
        }
    }
}

