/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl.compression;

import com.intel.gkl.NativeLibraryLoader;
import java.io.File;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadinstitute.gatk.nativebindings.NativeLibrary;

public final class IntelInflater
extends Inflater
implements NativeLibrary {
    private static final Log logger = LogFactory.getLog(IntelInflater.class);
    private static final String NATIVE_LIBRARY_NAME = "gkl_compression";
    private static boolean initialized = false;
    private static final Object lock_class = new Object();
    private long lz_stream;
    private byte[] inputBuffer;
    private int inputBufferLength;
    private int inputBufferOffset;
    private boolean finished;
    private boolean nowrap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean load(File tempDir) {
        Object object = lock_class;
        synchronized (object) {
            if (!NativeLibraryLoader.load(tempDir, NATIVE_LIBRARY_NAME)) {
                return false;
            }
            if (!initialized) {
                IntelInflater.initNative();
                initialized = true;
            }
        }
        return true;
    }

    private static native void initNative();

    private native void resetNative(boolean var1);

    private native int inflateNative(byte[] var1, int var2, int var3);

    private native void endNative();

    public IntelInflater(boolean nowrap) {
        if (!nowrap) {
            throw new IllegalArgumentException("ZLIB format is not supported at this time with Intel GKL");
        }
        this.nowrap = nowrap;
    }

    public IntelInflater() {
        this(true);
    }

    @Override
    public void reset() throws OutOfMemoryError {
        try {
            this.resetNative(this.nowrap);
        }
        catch (OutOfMemoryError e) {
            logger.warn("Exception thrown from native Inflater resetNative function call " + e.getMessage());
            throw new OutOfMemoryError("Memory allocation failed");
        }
        this.inputBuffer = null;
        this.inputBufferLength = 0;
        this.finished = false;
    }

    @Override
    public void setInput(byte[] b, int off, int len) {
        if (this.lz_stream == 0L) {
            this.reset();
        }
        if (b == null) {
            throw new NullPointerException("Input buffer is null");
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset value is less than zero");
        }
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException("Length value is less than zero");
        }
        if (off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException("Length value exceeds permissible range");
        }
        this.inputBuffer = b;
        this.inputBufferOffset = off;
        this.inputBufferLength = len;
    }

    @Override
    public int inflate(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException("Output buffer is null");
        }
        if (off < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset value is less than zero");
        }
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException("Length value is less than zero");
        }
        if (off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException("Length value exceeds permissible range");
        }
        if (this.inputBuffer == null || this.inputBufferLength == 0) {
            throw new NullPointerException("Input buffer is null");
        }
        int bytesWritten = this.inflateNative(b, off, len);
        return bytesWritten;
    }

    @Override
    public int inflate(byte[] b) {
        if (b == null) {
            throw new NullPointerException("Output buffer is null");
        }
        return this.inflateNative(b, 0, b.length);
    }

    @Override
    public boolean finished() {
        return this.finished;
    }

    @Override
    public void end() {
        if (this.lz_stream != 0L) {
            this.endNative();
            this.lz_stream = 0L;
        }
    }
}

