/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl.pairhmm;

import com.intel.gkl.IntelGKLUtils;
import com.intel.gkl.NativeLibraryLoader;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadinstitute.gatk.nativebindings.pairhmm.HaplotypeDataHolder;
import org.broadinstitute.gatk.nativebindings.pairhmm.PairHMMNativeArguments;
import org.broadinstitute.gatk.nativebindings.pairhmm.PairHMMNativeBinding;
import org.broadinstitute.gatk.nativebindings.pairhmm.ReadDataHolder;

public class IntelPairHmm
implements PairHMMNativeBinding {
    private static final Log logger = LogFactory.getLog(IntelPairHmm.class);
    private static final String NATIVE_LIBRARY_NAME = "gkl_pairhmm";
    private String nativeLibraryName = "gkl_pairhmm";
    private IntelGKLUtils gklUtils = new IntelGKLUtils();
    boolean useOmp = false;

    void setNativeLibraryName(String nativeLibraryName) {
        this.nativeLibraryName = nativeLibraryName;
    }

    public IntelPairHmm() {
        this.setNativeLibraryName(NATIVE_LIBRARY_NAME);
    }

    @Override
    public synchronized boolean load(File tempDir) {
        boolean isLoaded = this.gklUtils.load(null);
        if (!isLoaded) {
            logger.warn("Intel GKL Utils not loaded");
            return false;
        }
        if (!this.gklUtils.isAvxSupported()) {
            return false;
        }
        return NativeLibraryLoader.load(tempDir, this.nativeLibraryName);
    }

    @Override
    public void initialize(PairHMMNativeArguments args) {
        if (args == null) {
            args = new PairHMMNativeArguments();
            args.useDoublePrecision = false;
            args.maxNumberOfThreads = 1;
        }
        if (this.gklUtils.isAvx512Supported()) {
            logger.info("Using CPU-supported AVX-512 instructions");
        }
        if (!this.gklUtils.getFlushToZero()) {
            logger.info("Flush-to-zero (FTZ) is enabled when running PairHMM");
        }
        IntelPairHmm.initNative(ReadDataHolder.class, HaplotypeDataHolder.class, args.useDoublePrecision, args.maxNumberOfThreads);
        int reqThreads = args.maxNumberOfThreads;
        if (this.useOmp) {
            int availThreads = this.gklUtils.getAvailableOmpThreads();
            int maxThreads = Math.min(reqThreads, availThreads);
            logger.info(String.format("Available threads: %d", availThreads));
            logger.info(String.format("Requested threads: %d", reqThreads));
            if (reqThreads > availThreads) {
                logger.warn(String.format("Using %d available threads, but %d were requested", maxThreads, reqThreads));
            }
        } else if (reqThreads != 1) {
            logger.warn(String.format("Ignoring request for %d threads; not using OpenMP implementation", reqThreads));
        }
    }

    @Override
    public void computeLikelihoods(ReadDataHolder[] readDataArray, HaplotypeDataHolder[] haplotypeDataArray, double[] likelihoodArray) throws NullPointerException, OutOfMemoryError, IllegalArgumentException {
        if (readDataArray == null || haplotypeDataArray == null || likelihoodArray == null) {
            throw new NullPointerException("Input is null");
        }
        try {
            this.computeLikelihoodsNative(readDataArray, haplotypeDataArray, likelihoodArray);
        }
        catch (OutOfMemoryError e) {
            logger.warn("Exception thrown from native PairHMM computeLikelihoodsNative function call " + e.getMessage());
            throw new OutOfMemoryError("Memory allocation failed");
        }
        catch (IllegalArgumentException e) {
            logger.warn("Exception thrown from native PairHMM computeLikelihoodsNative function call " + e.getMessage());
            throw new IllegalArgumentException("Ran into invalid argument issue");
        }
    }

    @Override
    public void done() {
        this.doneNative();
    }

    private static native void initNative(Class<?> var0, Class<?> var1, boolean var2, int var3);

    private native void computeLikelihoodsNative(Object[] var1, Object[] var2, double[] var3);

    private native void doneNative();
}

