/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.bam;

import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.plugin.reads.ReadsEncoder;
import htsjdk.beta.plugin.reads.ReadsEncoderOptions;
import htsjdk.utils.ValidationUtils;

public abstract class BAMEncoder
implements ReadsEncoder {
    private final Bundle outputBundle;
    private final ReadsEncoderOptions readsEncoderOptions;
    private final String displayName;

    public BAMEncoder(Bundle outputBundle, ReadsEncoderOptions readsEncoderOptions) {
        ValidationUtils.nonNull(outputBundle, "outputBundle");
        ValidationUtils.nonNull(readsEncoderOptions, "readsEncoderOptions");
        this.outputBundle = outputBundle;
        this.readsEncoderOptions = readsEncoderOptions;
        this.displayName = outputBundle.getOrThrow("ALIGNED_READS").getDisplayName();
    }

    @Override
    public final String getFileFormat() {
        return "BAM";
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    public Bundle getOutputBundle() {
        return this.outputBundle;
    }

    public ReadsEncoderOptions getReadsEncoderOptions() {
        return this.readsEncoderOptions;
    }
}

