/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.io;

import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.io.HtsPath;
import htsjdk.io.IOPath;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;
import java.util.function.Function;

public class IOPathUtils {
    public static IOPath createTempPath(String prefix, String suffix) {
        try {
            File tempFile = File.createTempFile(prefix, suffix);
            tempFile.deleteOnExit();
            return new HtsPath(tempFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new HtsjdkIOException(e);
        }
    }

    public static String getStringFromPath(IOPath ioPath) {
        try {
            StringWriter stringWriter = new StringWriter();
            Files.lines(ioPath.toPath(), StandardCharsets.UTF_8).forEach(line -> {
                stringWriter.write((String)line);
                stringWriter.append("\n");
            });
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Failed to read from: %s", ioPath.getRawInputString()), e);
        }
    }

    public static void writeStringToPath(IOPath ioPath, String contents) {
        try (BufferedOutputStream bos = new BufferedOutputStream(ioPath.getOutputStream());){
            bos.write(contents.getBytes());
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Failed to write to: %s", ioPath.getRawInputString()), e);
        }
    }

    public static <T extends IOPath> T replaceExtension(IOPath path, String newExtension, Function<String, T> ioPathConstructor) {
        Object extensionToUse = newExtension.startsWith(".") ? newExtension : "." + newExtension;
        Optional<String> oldExtension = path.getExtension();
        if (oldExtension.isEmpty()) {
            throw new RuntimeException("The original path has no extension to replace" + path.getURIString());
        }
        String oldFileName = path.toPath().getFileName().toString();
        String newFileName = oldFileName.replaceAll(oldExtension.get() + "$", (String)extensionToUse);
        return (T)((IOPath)ioPathConstructor.apply(path.toPath().resolveSibling(newFileName).toUri().toString()));
    }

    public static <T extends IOPath> T appendExtension(IOPath path, String extension, Function<String, T> ioPathConstructor) {
        String oldFileName = path.toPath().getFileName().toString();
        Object newExtension = extension.startsWith(".") ? extension : "." + extension;
        return (T)((IOPath)ioPathConstructor.apply(path.toPath().resolveSibling(oldFileName + (String)newExtension).toUri().toString()));
    }
}

