/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin.registry;

import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.reads.ReadsBundle;
import htsjdk.beta.plugin.reads.ReadsCodec;
import htsjdk.beta.plugin.reads.ReadsDecoder;
import htsjdk.beta.plugin.reads.ReadsDecoderOptions;
import htsjdk.beta.plugin.reads.ReadsEncoder;
import htsjdk.beta.plugin.reads.ReadsEncoderOptions;
import htsjdk.beta.plugin.registry.HtsCodecResolver;
import htsjdk.io.IOPath;
import htsjdk.utils.ValidationUtils;

public class ReadsResolver
extends HtsCodecResolver<ReadsCodec> {
    public ReadsResolver() {
        super("ALIGNED_READS");
    }

    public ReadsDecoder getReadsDecoder(IOPath inputPath) {
        ValidationUtils.nonNull(inputPath, "Input path");
        return this.getReadsDecoder(ReadsBundle.resolveIndex(inputPath), new ReadsDecoderOptions());
    }

    public ReadsDecoder getReadsDecoder(IOPath inputPath, ReadsDecoderOptions readsDecoderOptions) {
        ValidationUtils.nonNull(inputPath, "Input path");
        ValidationUtils.nonNull(readsDecoderOptions, "Decoder options");
        return this.getReadsDecoder(ReadsBundle.resolveIndex(inputPath), readsDecoderOptions);
    }

    public ReadsDecoder getReadsDecoder(Bundle inputBundle) {
        ValidationUtils.nonNull(inputBundle, "Input bundle");
        return this.getReadsDecoder(inputBundle, new ReadsDecoderOptions());
    }

    public ReadsDecoder getReadsDecoder(Bundle inputBundle, ReadsDecoderOptions readsDecoderOptions) {
        ValidationUtils.nonNull(inputBundle, "Input bundle");
        ValidationUtils.nonNull(readsDecoderOptions, "Decoder options");
        return (ReadsDecoder)((ReadsCodec)this.resolveForDecoding(inputBundle)).getDecoder(inputBundle, readsDecoderOptions);
    }

    public ReadsEncoder getReadsEncoder(IOPath outputPath) {
        ValidationUtils.nonNull(outputPath, "Output path");
        return this.getReadsEncoder(outputPath, new ReadsEncoderOptions());
    }

    public ReadsEncoder getReadsEncoder(IOPath outputPath, ReadsEncoderOptions readsEncoderOptions) {
        ValidationUtils.nonNull(outputPath, "Output path");
        ValidationUtils.nonNull(readsEncoderOptions, "Encoder options");
        return this.getReadsEncoder(new ReadsBundle<IOPath>(outputPath), readsEncoderOptions);
    }

    public ReadsEncoder getReadsEncoder(Bundle outputBundle, ReadsEncoderOptions readsEncoderOptions) {
        ValidationUtils.nonNull(outputBundle, "outputBundle");
        ValidationUtils.nonNull(readsEncoderOptions, "Encoder options");
        return (ReadsEncoder)((ReadsCodec)this.resolveForEncoding(outputBundle)).getEncoder(outputBundle, readsEncoderOptions);
    }

    public ReadsEncoder getReadsEncoder(Bundle outputBundle, ReadsEncoderOptions readsEncoderOptions, String readsFormat, HtsVersion formatVersion) {
        ValidationUtils.nonNull(outputBundle, "Output bundle");
        ValidationUtils.nonNull(readsFormat, "Reads format");
        ValidationUtils.nonNull(formatVersion, "File format version");
        return (ReadsEncoder)((ReadsCodec)this.resolveFormatAndVersion(readsFormat, formatVersion)).getEncoder(outputBundle, readsEncoderOptions);
    }
}

