/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.plugin.registry;

import htsjdk.beta.codecs.variants.vcf.vcfv4_2.VCFCodecV4_2;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleBuilder;
import htsjdk.beta.io.bundle.IOPathResource;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.registry.HtsCodecResolver;
import htsjdk.beta.plugin.variants.VariantsCodec;
import htsjdk.beta.plugin.variants.VariantsDecoder;
import htsjdk.beta.plugin.variants.VariantsDecoderOptions;
import htsjdk.beta.plugin.variants.VariantsEncoder;
import htsjdk.beta.plugin.variants.VariantsEncoderOptions;
import htsjdk.io.IOPath;
import htsjdk.utils.ValidationUtils;

public class VariantsResolver
extends HtsCodecResolver<VariantsCodec> {
    public VariantsResolver() {
        super("VARIANT_CONTEXTS");
    }

    public VariantsDecoder getVariantsDecoder(IOPath inputPath) {
        ValidationUtils.nonNull(inputPath, "Input path");
        return this.getVariantsDecoder(inputPath, new VariantsDecoderOptions());
    }

    public VariantsDecoder getVariantsDecoder(IOPath inputPath, VariantsDecoderOptions variantsDecoderOptions) {
        ValidationUtils.nonNull(inputPath, "Input path");
        ValidationUtils.nonNull(variantsDecoderOptions, "Decoder options");
        Bundle inputBundle = new BundleBuilder().addPrimary(new IOPathResource(inputPath, "VARIANT_CONTEXTS")).build();
        return this.getVariantsDecoder(inputBundle, variantsDecoderOptions);
    }

    public VariantsDecoder getVariantsDecoder(Bundle inputBundle) {
        ValidationUtils.nonNull(inputBundle, "Input bundle");
        VariantsCodec variantsCodec = (VariantsCodec)this.resolveForDecoding(inputBundle);
        return (VariantsDecoder)variantsCodec.getDecoder(inputBundle, new VariantsDecoderOptions());
    }

    public VariantsDecoder getVariantsDecoder(Bundle inputBundle, VariantsDecoderOptions variantsDecoderOptions) {
        ValidationUtils.nonNull(inputBundle, "Input bundle");
        ValidationUtils.nonNull(variantsDecoderOptions, "Decoder options");
        VariantsCodec variantsCodec = (VariantsCodec)this.resolveForDecoding(inputBundle);
        return (VariantsDecoder)variantsCodec.getDecoder(inputBundle, variantsDecoderOptions);
    }

    public VariantsEncoder getVariantsEncoder(IOPath outputPath) {
        ValidationUtils.nonNull(outputPath, "Output path");
        return this.getVariantsEncoder(outputPath, new VariantsEncoderOptions());
    }

    public VariantsEncoder getVariantsEncoder(IOPath outputPath, VariantsEncoderOptions variantsEncoderOptions) {
        ValidationUtils.nonNull(outputPath, "Output path");
        ValidationUtils.nonNull(variantsEncoderOptions, "Encoder options");
        Bundle outputBundle = new BundleBuilder().addPrimary(new IOPathResource(outputPath, "VARIANT_CONTEXTS")).build();
        return this.getVariantsEncoder(outputBundle, variantsEncoderOptions);
    }

    public VariantsEncoder getVariantsEncoder(Bundle outputBundle, VariantsEncoderOptions variantsEncoderOptions) {
        ValidationUtils.nonNull(outputBundle, "Output bundle");
        ValidationUtils.nonNull(variantsEncoderOptions, "Encoder options");
        VariantsCodec variantsCodec = (VariantsCodec)this.resolveForEncoding(outputBundle, VCFCodecV4_2.VCF_V42_VERSION);
        return (VariantsEncoder)variantsCodec.getEncoder(outputBundle, variantsEncoderOptions);
    }

    public VariantsEncoder getVariantsEncoder(Bundle outputBundle, VariantsEncoderOptions variantsEncoderOptions, String variantsFormat, HtsVersion formatVersion) {
        ValidationUtils.nonNull(outputBundle, "Output bundle");
        ValidationUtils.nonNull(variantsEncoderOptions, "Encoder options");
        ValidationUtils.nonNull(variantsFormat, "Format");
        ValidationUtils.nonNull(formatVersion, "Format version");
        return (VariantsEncoder)((VariantsCodec)this.resolveFormatAndVersion(variantsFormat, formatVersion)).getEncoder(outputBundle, variantsEncoderOptions);
    }
}

