/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.HtsgetInputResource;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.sra.SRAAccession;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;

abstract class InputResource {
    private final Type type;

    protected InputResource(Type type) {
        this.type = type;
    }

    final Type type() {
        return this.type;
    }

    abstract File asFile();

    abstract Path asPath();

    abstract URL asUrl();

    abstract SeekableStream asUnbufferedSeekableStream();

    abstract InputStream asUnbufferedInputStream();

    abstract SRAAccession asSRAAccession();

    public String toString() {
        return String.format("%s:%s", new Object[]{this.type(), switch (this.type()) {
            case Type.FILE -> this.asFile().toString();
            case Type.PATH -> this.asPath().toString();
            case Type.INPUT_STREAM -> this.asUnbufferedInputStream().toString();
            case Type.SEEKABLE_STREAM -> this.asUnbufferedSeekableStream().toString();
            case Type.URL -> this.asUrl().toString();
            case Type.SRA_ACCESSION -> this.asSRAAccession().toString();
            case Type.HTSGET -> ((HtsgetInputResource)this).uri.toString();
            default -> throw new IllegalStateException();
        }});
    }

    static enum Type {
        FILE,
        PATH,
        URL,
        SEEKABLE_STREAM,
        INPUT_STREAM,
        SRA_ACCESSION,
        HTSGET;

    }
}

