/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression;

import htsjdk.samtools.cram.compression.CompressionUtils;
import htsjdk.samtools.cram.compression.ExternalCompressor;
import htsjdk.samtools.cram.compression.rans.RANSParams;
import htsjdk.samtools.cram.compression.rans.rans4x8.RANS4x8Decode;
import htsjdk.samtools.cram.compression.rans.rans4x8.RANS4x8Encode;
import htsjdk.samtools.cram.compression.rans.rans4x8.RANS4x8Params;
import htsjdk.samtools.cram.structure.block.BlockCompressionMethod;
import java.nio.ByteBuffer;
import java.util.Objects;

public final class RANSExternalCompressor
extends ExternalCompressor {
    private final RANSParams.ORDER order;
    private final RANS4x8Encode ransEncode;
    private final RANS4x8Decode ransDecode;

    public RANSExternalCompressor(RANS4x8Encode ransEncode, RANS4x8Decode ransDecode) {
        this(RANSParams.ORDER.ZERO, ransEncode, ransDecode);
    }

    public RANSExternalCompressor(int order, RANS4x8Encode ransEncode, RANS4x8Decode ransDecode) {
        this(RANSParams.ORDER.fromInt(order), ransEncode, ransDecode);
    }

    public RANSExternalCompressor(RANSParams.ORDER order, RANS4x8Encode ransEncode, RANS4x8Decode ransDecode) {
        super(BlockCompressionMethod.RANS);
        this.ransEncode = ransEncode;
        this.ransDecode = ransDecode;
        this.order = order;
    }

    @Override
    public byte[] compress(byte[] data) {
        RANS4x8Params params = new RANS4x8Params(this.order);
        ByteBuffer buffer = this.ransEncode.compress(CompressionUtils.wrap(data), params);
        return this.toByteArray(buffer);
    }

    @Override
    public byte[] uncompress(byte[] data) {
        ByteBuffer buf = this.ransDecode.uncompress(CompressionUtils.wrap(data));
        return this.toByteArray(buf);
    }

    @Override
    public String toString() {
        return String.format("%s(%s)", new Object[]{this.getMethod(), this.order});
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RANSExternalCompressor that = (RANSExternalCompressor)o;
        return this.order == that.order;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getMethod(), this.order});
    }

    private byte[] toByteArray(ByteBuffer buffer) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.array().length == buffer.limit()) {
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }
}

