/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.fqzcomp;

import java.nio.ByteBuffer;

public class FQZUtils {
    public static void readArray(ByteBuffer inBuffer, int[] table, int size) {
        int j = 0;
        int z = 0;
        int last = -1;
        int[] rle = new int[1024];
        while (z < size) {
            int run = inBuffer.get() & 0xFF;
            rle[j++] = run;
            z += run;
            if (run == last) {
                int copy = inBuffer.get() & 0xFF;
                z += run * copy;
                while (copy-- > 0) {
                    rle[j++] = run;
                }
            }
            last = run;
        }
        int i = 0;
        j = 0;
        z = 0;
        while (z < size) {
            int part;
            int run_len = 0;
            do {
                part = rle[j++];
                run_len += part;
            } while (part == 255);
            while (run_len-- > 0) {
                table[z++] = i;
            }
            ++i;
        }
    }
}

