/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.nametokenisation;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.compression.CompressionUtils;
import htsjdk.samtools.cram.compression.nametokenisation.TokenStreams;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class NameTokenisationDecode {
    public static final byte NAME_SEPARATOR = 0;
    public static final int DEFAULT_POSITION_ALLOCATION = 30;

    public byte[] uncompress(ByteBuffer inBuffer, byte nameSeparator) {
        inBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int uncompressedLength = inBuffer.getInt();
        int numNames = inBuffer.getInt() & 0xFFFFFFFF;
        int useArith = inBuffer.get() & 0xFF;
        TokenStreams tokenStreams = new TokenStreams(inBuffer, useArith, numNames);
        ArrayList<List<String>> decodedNameTokens = new ArrayList<List<String>>(numNames);
        ByteBuffer decodedNames = CompressionUtils.allocateByteBuffer(uncompressedLength);
        for (int i = 0; i < numNames; ++i) {
            decodedNames.put(this.decodeSingleName(tokenStreams, decodedNameTokens, i));
            decodedNames.put(nameSeparator);
        }
        return decodedNames.array();
    }

    private byte[] decodeSingleName(TokenStreams tokenStreams, List<List<String>> decodedNameTokens, int currentNameIndex) {
        byte referenceType = tokenStreams.getStream(0, 0).get();
        ByteBuffer distStream = tokenStreams.getStream(0, referenceType);
        int referenceName = currentNameIndex - distStream.getInt() & 0xFFFFFFFF;
        if (referenceType == 5) {
            decodedNameTokens.add(currentNameIndex, decodedNameTokens.get(referenceName));
            return String.join((CharSequence)"", (Iterable<? extends CharSequence>)decodedNameTokens.get(currentNameIndex)).getBytes();
        }
        if (referenceType != 6) {
            throw new CRAMException(String.format("Invalid nameType %s. nameType must be either TOKEN_DIFF or TOKEN_DUP", referenceType));
        }
        ArrayList<String> currentNameTokens = new ArrayList<String>(30);
        StringBuilder decodedNameBuilder = new StringBuilder();
        byte type = -1;
        int tokenPos = 1;
        while (type != 12) {
            type = tokenStreams.getStream(tokenPos, 0).get();
            String currentToken = "";
            switch (type) {
                case 2: {
                    char currentTokenChar = (char)tokenStreams.getStream(tokenPos, 2).get();
                    currentToken = String.valueOf(currentTokenChar);
                    break;
                }
                case 1: {
                    currentToken = this.readString(tokenStreams.getStream(tokenPos, 1));
                    break;
                }
                case 7: {
                    currentToken = this.getDigitsToken(tokenStreams, tokenPos, (byte)7);
                    break;
                }
                case 3: {
                    String digits0Token = this.getDigitsToken(tokenStreams, tokenPos, (byte)3);
                    int lenDigits0Token = tokenStreams.getStream(tokenPos, 4).get() & 0xFF;
                    currentToken = this.leftPadWith0(digits0Token, lenDigits0Token);
                    break;
                }
                case 8: {
                    currentToken = this.getDeltaToken(tokenStreams, tokenPos, (byte)8, decodedNameTokens, referenceName);
                    break;
                }
                case 9: {
                    String delta0Token = this.getDeltaToken(tokenStreams, tokenPos, (byte)9, decodedNameTokens, referenceName);
                    int lenDelta0Token = decodedNameTokens.get(referenceName).get(tokenPos - 1).length();
                    currentToken = this.leftPadWith0(delta0Token, lenDelta0Token);
                    break;
                }
                case 10: {
                    currentToken = decodedNameTokens.get(referenceName).get(tokenPos - 1);
                    break;
                }
                case 12: {
                    break;
                }
                case 11: {
                    break;
                }
                default: {
                    throw new CRAMException(String.format("Invalid tokenType : %s. tokenType must be one of the valid token types", type));
                }
            }
            currentNameTokens.add(tokenPos - 1, currentToken);
            decodedNameBuilder.append(currentToken);
            ++tokenPos;
        }
        decodedNameTokens.add(currentNameIndex, currentNameTokens);
        return decodedNameBuilder.toString().getBytes();
    }

    private String getDeltaToken(TokenStreams tokenStreams, int tokenPosition, byte tokenType, List<List<String>> previousTokensList, int prevNameIndex) {
        if (tokenType != 8 && tokenType != 9) {
            throw new CRAMException(String.format("Invalid delta tokenType %s must be either TOKEN_DELTA or TOKEN_DELTA0", tokenType));
        }
        try {
            String prevToken = previousTokensList.get(prevNameIndex).get(tokenPosition - 1);
            int prevTokenInt = Integer.parseInt(prevToken);
            int deltaTokenValue = tokenStreams.getStream(tokenPosition, tokenType).get() & 0xFF;
            return Long.toString(prevTokenInt + deltaTokenValue);
        }
        catch (NumberFormatException e) {
            throw new CRAMException(String.format("The token in the prior name must be of type %s", tokenType == 8 ? "DIGITS or DELTA" : "DIGITS0 or DELTA0", e));
        }
    }

    private String getDigitsToken(TokenStreams tokenStreams, int tokenPosition, byte tokenType) {
        if (tokenType != 7 && tokenType != 3) {
            throw new CRAMException(String.format("Invalid tokenType: %s tokenType must be either TOKEN_DIGITS or TOKEN_DIGITS0", tokenType));
        }
        ByteBuffer digitsByteBuffer = tokenStreams.getStream(tokenPosition, tokenType);
        long digits = (long)digitsByteBuffer.getInt() & 0xFFFFFFFFL;
        return Long.toString(digits);
    }

    private String readString(ByteBuffer inputBuffer) {
        int pos;
        int count = pos = inputBuffer.position();
        while (inputBuffer.get(count) != 0) {
            ++count;
        }
        String s2 = new String(inputBuffer.array(), pos + inputBuffer.arrayOffset(), count - pos, StandardCharsets.UTF_8);
        inputBuffer.position(count + 1);
        return s2;
    }

    private String leftPadWith0(String value, int len) {
        if (value.length() >= len) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("0".repeat(Math.max(0, len - value.length())));
        sb.append(value);
        return sb.toString();
    }
}

