/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.samtools.cram.compression.rans.RANSEncodingSymbol;
import htsjdk.samtools.cram.compression.rans.RANSParams;
import java.nio.ByteBuffer;

public abstract class RANSEncode<T extends RANSParams> {
    private RANSEncodingSymbol[][] encodingSymbols;

    protected RANSEncodingSymbol[][] getEncodingSymbols() {
        return this.encodingSymbols;
    }

    public abstract ByteBuffer compress(ByteBuffer var1, T var2);

    protected void initializeRANSEncoder() {
        if (this.encodingSymbols == null) {
            this.encodingSymbols = new RANSEncodingSymbol[256][256];
            for (int i = 0; i < this.encodingSymbols.length; ++i) {
                for (int j = 0; j < this.encodingSymbols[i].length; ++j) {
                    this.encodingSymbols[i][j] = new RANSEncodingSymbol();
                }
            }
        } else {
            for (int i = 0; i < this.encodingSymbols.length; ++i) {
                for (int j = 0; j < this.encodingSymbols[i].length; ++j) {
                    this.encodingSymbols[i][j].reset();
                }
            }
        }
    }

    protected void buildSymsOrder0(int[] frequencies) {
        this.updateEncodingSymbols(frequencies, this.getEncodingSymbols()[0]);
    }

    protected void buildSymsOrder1(int[][] frequencies) {
        RANSEncodingSymbol[][] encodingSymbols = this.getEncodingSymbols();
        for (int i = 0; i < 256; ++i) {
            this.updateEncodingSymbols(frequencies[i], encodingSymbols[i]);
        }
    }

    private void updateEncodingSymbols(int[] frequencies, RANSEncodingSymbol[] encodingSymbols) {
        int cumulativeFreq = 0;
        for (int symbol = 0; symbol < 256; ++symbol) {
            if (frequencies[symbol] == 0) continue;
            encodingSymbols[symbol].set(cumulativeFreq, frequencies[symbol], 12);
            cumulativeFreq += frequencies[symbol];
        }
    }
}

