/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.utils.ValidationUtils;
import java.nio.ByteBuffer;

public final class RANSEncodingSymbol {
    private long xMax;
    private int rcpFreq;
    private int bias;
    private int cmplFreq;
    private int rcpShift;

    public void reset() {
        this.rcpShift = 0;
        this.cmplFreq = 0;
        this.bias = 0;
        this.rcpFreq = 0;
        this.xMax = 0;
    }

    public void set(int start, int freq, int scaleBits) {
        this.xMax = (1L << 31 - scaleBits) * (long)freq;
        this.cmplFreq = (1 << scaleBits) - freq;
        if (freq < 2) {
            this.rcpFreq = -1;
            this.rcpShift = 0;
            this.bias = start + (1 << scaleBits) - 1;
        } else {
            int shift = 0;
            while ((long)freq > 1L << shift) {
                ++shift;
            }
            this.rcpFreq = (int)(((1L << shift + 31) + (long)freq - 1L) / (long)freq);
            this.rcpShift = shift - 1;
            this.bias = start;
        }
        this.rcpShift += 32;
    }

    public long putSymbol4x8(long r, ByteBuffer byteBuffer) {
        ValidationUtils.validateArg(this.xMax != 0L, "can't encode symbol with freq=0");
        long retSymbol = r;
        if (retSymbol >= this.xMax) {
            byteBuffer.put((byte)(retSymbol & 0xFFL));
            if ((retSymbol >>= 8) >= this.xMax) {
                byteBuffer.put((byte)(retSymbol & 0xFFL));
                retSymbol >>= 8;
            }
        }
        long q = retSymbol * (0xFFFFFFFFL & (long)this.rcpFreq) >> this.rcpShift;
        return retSymbol + (long)this.bias + q * (long)this.cmplFreq;
    }

    public long putSymbolNx16(long r, ByteBuffer byteBuffer) {
        ValidationUtils.validateArg(this.xMax != 0L, "can't encode symbol with freq=0");
        long retSymbol = r;
        if (retSymbol >= this.xMax) {
            byteBuffer.put((byte)(retSymbol >> 8 & 0xFFL));
            byteBuffer.put((byte)(retSymbol & 0xFFL));
            if ((retSymbol >>= 16) >= this.xMax) {
                byteBuffer.put((byte)(retSymbol >> 8 & 0xFFL));
                byteBuffer.put((byte)(retSymbol & 0xFFL));
                retSymbol >>= 16;
            }
        }
        long q = retSymbol * (0xFFFFFFFFL & (long)this.rcpFreq) >> this.rcpShift;
        return retSymbol + (long)this.bias + q * (long)this.cmplFreq;
    }
}

