/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core.experimental;

import htsjdk.samtools.cram.encoding.core.experimental.ExperimentalCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;

class GolombLongCodec
extends ExperimentalCodec<Long> {
    private final boolean QUOTIENT_BIT = true;
    private final int m;
    private final long offset;

    public GolombLongCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, long offset, int m4) {
        super(coreBlockInputStream, coreBlockOutputStream);
        if (m4 < 2) {
            throw new IllegalArgumentException("M parameter must be at least 2.");
        }
        this.m = m4;
        this.offset = offset;
    }

    @Override
    public final Long read() {
        long quotient = 0L;
        while (this.coreBlockInputStream.readBit()) {
            ++quotient;
        }
        long ceiling = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        long reminder = this.coreBlockInputStream.readBits((int)(ceiling - 1L));
        if ((double)reminder >= Math.pow(2.0, ceiling) - (double)this.m) {
            reminder <<= 1;
            reminder |= (long)this.coreBlockInputStream.readBits(1);
            reminder = (long)((double)reminder - (Math.pow(2.0, ceiling) - (double)this.m));
        }
        return quotient * (long)this.m + reminder - this.offset;
    }

    @Override
    public final void write(Long value) {
        long newValue = value + this.offset;
        long quotient = newValue / (long)this.m;
        long reminder = newValue % (long)this.m;
        long ceiling = (long)(Math.log(this.m) / Math.log(2.0) + 1.0);
        this.coreBlockOutputStream.write(true, quotient);
        this.coreBlockOutputStream.write(false);
        if ((double)reminder < Math.pow(2.0, ceiling) - (double)this.m) {
            this.coreBlockOutputStream.write(reminder, (int)ceiling - 1);
        } else {
            this.coreBlockOutputStream.write((int)((double)reminder + Math.pow(2.0, ceiling) - (double)this.m), (int)ceiling);
        }
    }

    @Override
    public Long read(int length) {
        throw new RuntimeException("Multi-value read method not defined.");
    }

    public String toString() {
        return String.format("offset: %d m: %d", this.offset, this.m);
    }
}

