/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core.experimental;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.core.experimental.ExperimentalEncoding;
import htsjdk.samtools.cram.encoding.core.experimental.GolombRiceIntegerCodec;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.SliceBlocksReadStreams;
import htsjdk.samtools.cram.structure.SliceBlocksWriteStreams;
import java.nio.ByteBuffer;

public final class GolombRiceIntegerEncoding
extends ExperimentalEncoding<Integer> {
    private final int offset;
    private final int m;

    public GolombRiceIntegerEncoding(int offset, int m4) {
        super(EncodingID.GOLOMB_RICE);
        this.offset = offset;
        this.m = m4;
    }

    public static GolombRiceIntegerEncoding fromSerializedEncodingParams(byte[] serializedParams) {
        ByteBuffer buffer = ByteBuffer.wrap(serializedParams);
        int offset = ITF8.readUnsignedITF8(buffer);
        int m4 = ITF8.readUnsignedITF8(buffer);
        return new GolombRiceIntegerEncoding(offset, m4);
    }

    @Override
    public byte[] toSerializedEncodingParams() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(this.offset, buffer);
        ITF8.writeUnsignedITF8(this.m, buffer);
        buffer.flip();
        byte[] array = new byte[buffer.limit()];
        buffer.get(array);
        return array;
    }

    @Override
    public CRAMCodec<Integer> buildCodec(SliceBlocksReadStreams sliceBlocksReadStreams, SliceBlocksWriteStreams sliceBlocksWriteStreams) {
        return new GolombRiceIntegerCodec(sliceBlocksReadStreams == null ? null : sliceBlocksReadStreams.getCoreBlockInputStream(), sliceBlocksWriteStreams == null ? null : sliceBlocksWriteStreams.getCoreOutputStream(), this.offset, this.m);
    }

    public String toString() {
        return String.format("Offset: %d m: %d", this.offset, this.m);
    }
}

