/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core.huffmanUtils;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.core.huffmanUtils.HuffmanParams;
import htsjdk.samtools.cram.encoding.core.huffmanUtils.HuffmanTree;
import htsjdk.utils.ValidationUtils;
import java.util.HashMap;

public class HuffmanParamsCalculator<T> {
    private final HashMap<T, MutableInt> symbolFrequencies = new HashMap();

    public void addSymbolObservations(T symbol, int numberOfObservations) {
        ValidationUtils.validateArg(numberOfObservations > 0, "number of observations must be > 0");
        this.symbolFrequencies.compute(symbol, (s2, f) -> f == null ? new MutableInt(numberOfObservations) : f.incrementValue(numberOfObservations));
    }

    public HuffmanParams<T> getHuffmanParams() {
        ValidationUtils.validateArg(this.symbolFrequencies.size() > 0, "no symbols to encode");
        HuffmanTree<T> tree = HuffmanTree.buildTree(this.symbolFrequencies);
        return tree.getHuffmanParams();
    }
}

