/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class GZIIndex {
    @Deprecated
    public static final String DEFAULT_EXTENSION = ".gzi";
    private final List<IndexEntry> entries;

    private GZIIndex(List<IndexEntry> entries) {
        this.entries = Collections.unmodifiableList(entries);
    }

    public int getNumberOfBlocks() {
        return this.entries.size() + 1;
    }

    public List<IndexEntry> getIndexEntries() {
        return this.entries;
    }

    public long getVirtualOffsetForSeek(long uncompressedOffset) {
        try {
            if (uncompressedOffset == 0L) {
                return BlockCompressedFilePointerUtil.makeFilePointer(0L, 0);
            }
            int pos = Collections.binarySearch(this.entries, new IndexEntry(0L, uncompressedOffset), Comparator.comparingLong(IndexEntry::getUncompressedOffset));
            if (pos >= 0) {
                return BlockCompressedFilePointerUtil.makeFilePointer(this.entries.get(pos).getCompressedOffset(), 0);
            }
            int entryPos = -pos - 2;
            if (entryPos == -1) {
                return BlockCompressedFilePointerUtil.makeFilePointer(0L, Math.toIntExact(uncompressedOffset));
            }
            IndexEntry indexEntry = this.entries.get(entryPos);
            int blockOffset = Math.toIntExact(uncompressedOffset - indexEntry.getUncompressedOffset());
            return BlockCompressedFilePointerUtil.makeFilePointer(indexEntry.getCompressedOffset(), blockOffset);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Cannot handle offsets within blocks larger than 2147483647", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof GZIIndex)) {
            return false;
        }
        return this.entries.equals(((GZIIndex)obj).entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        return "GZIIndex:" + StringUtil.join(", ", this.entries);
    }

    public void writeIndex(Path output) throws IOException {
        this.writeIndex(Files.newOutputStream(output, new OpenOption[0]));
    }

    public void writeIndex(OutputStream output) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("null output path");
        }
        BinaryCodec codec = new BinaryCodec(output);
        int numberOfBlocksToWrite = this.entries.size();
        codec.writeLong(Integer.toUnsignedLong(numberOfBlocksToWrite));
        for (IndexEntry entry : this.entries) {
            codec.writeLong(entry.getCompressedOffset());
            codec.writeLong(entry.getUncompressedOffset());
        }
        codec.close();
    }

    public static final GZIIndex loadIndex(Path indexPath) throws IOException {
        if (indexPath == null) {
            throw new IllegalArgumentException("null input path");
        }
        try (SeekableByteChannel channel = Files.newByteChannel(indexPath, new OpenOption[0]);){
            GZIIndex gZIIndex = GZIIndex.loadIndex(indexPath.toUri().toString(), channel);
            return gZIIndex;
        }
    }

    public static final GZIIndex loadIndex(String source, InputStream indexIn) throws IOException {
        if (indexIn == null) {
            throw new IllegalArgumentException("null input stream");
        }
        try (ReadableByteChannel channel = Channels.newChannel(indexIn);){
            GZIIndex gZIIndex = GZIIndex.loadIndex(source, channel);
            return gZIIndex;
        }
    }

    public static final GZIIndex loadIndex(String source, ReadableByteChannel channel) throws IOException {
        int numberOfEntries;
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (8 != channel.read(buffer)) {
            throw GZIIndex.getCorruptedIndexException(source, "less than 8bytes", null);
        }
        buffer.flip();
        try {
            numberOfEntries = Math.toIntExact(buffer.getLong());
        }
        catch (ArithmeticException e) {
            buffer.flip();
            throw GZIIndex.getCorruptedIndexException(source, String.format("HTSJDK cannot handle more than %d entries in .gzi index, but found %s", Integer.MAX_VALUE, buffer.getLong()), e);
        }
        ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>(numberOfEntries);
        buffer = GZIIndex.allocateBuffer(numberOfEntries, false);
        channel.read(buffer);
        buffer.flip();
        for (int i = 0; i < numberOfEntries; ++i) {
            IndexEntry entry;
            try {
                entry = new IndexEntry(buffer.getLong(), buffer.getLong());
            }
            catch (IllegalArgumentException e) {
                throw GZIIndex.getCorruptedIndexException(source, e.getMessage(), e);
            }
            if (i == 0) {
                if (entry.getUncompressedOffset() == 0L && entry.getCompressedOffset() == 0L) {
                    throw GZIIndex.getCorruptedIndexException(source, "first block index entry should not be present", null);
                }
            } else if (((IndexEntry)entries.get(i - 1)).getCompressedOffset() >= entry.getCompressedOffset() || ((IndexEntry)entries.get(i - 1)).getUncompressedOffset() >= entry.getUncompressedOffset()) {
                throw GZIIndex.getCorruptedIndexException(source, String.format("index entries in misplaced order - %s vs %s", entries.get(i - 1), entry), null);
            }
            entries.add(entry);
        }
        return new GZIIndex(entries);
    }

    private static final IOException getCorruptedIndexException(String source, String msg, Exception e) {
        return new IOException(String.format("Corrupted index file: %s (%s)", msg, source == null ? "unknown" : source), e);
    }

    public static final GZIIndex buildIndex(Path bgzipFile) throws IOException {
        if (bgzipFile == null) {
            throw new IllegalArgumentException("null input path");
        }
        try (BlockCompressedInputStream bgzipStream = new BlockCompressedInputStream(Files.newInputStream(bgzipFile, new OpenOption[0]));){
            ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
            int currentOffset = 0;
            while (bgzipStream.read() != -1) {
                ++currentOffset;
                if (!bgzipStream.endOfBlock()) continue;
                long compressed = BlockCompressedFilePointerUtil.getBlockAddress(bgzipStream.getFilePointer());
                entries.add(new IndexEntry(compressed, currentOffset));
            }
            GZIIndex gZIIndex = new GZIIndex(entries);
            return gZIIndex;
        }
    }

    public static GZIIndex createIndex(Path bgzipFile, boolean overwrite) throws IOException {
        Path indexFile = GZIIndex.resolveIndexNameForBgzipFile(bgzipFile);
        if (!overwrite && Files.exists(indexFile, new LinkOption[0])) {
            throw new IOException("Index file " + String.valueOf(indexFile) + " already exists for " + String.valueOf(bgzipFile));
        }
        GZIIndex index = GZIIndex.buildIndex(bgzipFile);
        index.writeIndex(new BufferedOutputStream(Files.newOutputStream(indexFile, new OpenOption[0])));
        return index;
    }

    public static Path resolveIndexNameForBgzipFile(Path bgzipFile) {
        return bgzipFile.resolveSibling(bgzipFile.getFileName().toString() + DEFAULT_EXTENSION);
    }

    private static final ByteBuffer allocateBuffer(int numberOfEntries, boolean includeNumberOfEntries) {
        int size = includeNumberOfEntries ? 8 : 0;
        return ByteBuffer.allocate(size += numberOfEntries * 2 * 8).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static final class IndexEntry {
        private final long compressedOffset;
        private final long uncompressedOffset;

        private IndexEntry(long compressedOffset, long uncompressedOffset) {
            if (compressedOffset < 0L) {
                throw new IllegalArgumentException("negative compressed offset: " + compressedOffset);
            }
            if (uncompressedOffset < 0L) {
                throw new IllegalArgumentException("negative uncompressed offset: " + uncompressedOffset);
            }
            this.compressedOffset = compressedOffset;
            this.uncompressedOffset = uncompressedOffset;
        }

        public long getCompressedOffset() {
            return this.compressedOffset;
        }

        public long getUncompressedOffset() {
            return this.uncompressedOffset;
        }

        public String toString() {
            return String.format("IndexEntry={compressed=%d(0x%x),uncompressed=%d(0x%x)", this.compressedOffset, this.compressedOffset, this.uncompressedOffset, this.uncompressedOffset);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof IndexEntry)) {
                return false;
            }
            IndexEntry other = (IndexEntry)obj;
            return this.compressedOffset == other.compressedOffset && this.uncompressedOffset == other.uncompressedOffset;
        }

        public int hashCode() {
            return 31 * Long.hashCode(this.compressedOffset) + Long.hashCode(this.uncompressedOffset);
        }
    }

    public static final class GZIIndexer
    implements Closeable {
        private int uncompressedFileOffset;
        private final OutputStream output;
        private final List<IndexEntry> entries = new ArrayList<IndexEntry>();

        public GZIIndexer(OutputStream outputStream) {
            this.output = outputStream;
        }

        public GZIIndexer(Path outputFile) throws IOException {
            this.output = Files.newOutputStream(outputFile, new OpenOption[0]);
        }

        public void addGzipBlock(long compressedFileOffset, long uncompressedBlockSize) {
            IndexEntry indexEntry = new IndexEntry(compressedFileOffset, this.uncompressedFileOffset);
            this.uncompressedFileOffset = (int)((long)this.uncompressedFileOffset + uncompressedBlockSize);
            this.entries.add(indexEntry);
        }

        @Override
        public void close() throws IOException {
            GZIIndex index = new GZIIndex(this.entries);
            index.writeIndex(this.output);
        }
    }
}

