/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.argparser;

import java.util.function.DoubleFunction;

public class CommandLineException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public CommandLineException(String msg) {
        super(msg);
    }

    public CommandLineException(String message, Throwable throwable) {
        super(message, throwable);
    }

    static class ShouldNeverReachHereException
    extends CommandLineParserInternalException {
        private static final long serialVersionUID = 0L;

        public ShouldNeverReachHereException(String s2) {
            super(s2);
        }

        public ShouldNeverReachHereException(String s2, Throwable throwable) {
            super(s2, throwable);
        }

        public ShouldNeverReachHereException(Throwable throwable) {
            this("Barclay command line parser; should never reach here.", throwable);
        }
    }

    public static class CommandLineParserInternalException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        public CommandLineParserInternalException(String s2) {
            super(s2);
        }

        public CommandLineParserInternalException(String s2, Throwable throwable) {
            super(s2, throwable);
        }
    }

    public static class OutOfRangeArgumentValue
    extends BadArgumentValue {
        private static final long serialVersionUID = 0L;

        public OutOfRangeArgumentValue(String argName, double minValue, double maxValue, Object value) {
            super(argName, OutOfRangeArgumentValue.getValueString(value), OutOfRangeArgumentValue.getMessage(minValue, maxValue, value instanceof Integer));
        }

        private static String getValueString(Object value) {
            return value == null ? "null" : value.toString();
        }

        private static String getMessage(double minValue, double maxValue, boolean asInt) {
            DoubleFunction<String> toString;
            boolean outMinValue = minValue != Double.NEGATIVE_INFINITY;
            boolean outMaxValue = maxValue != Double.POSITIVE_INFINITY;
            DoubleFunction<String> doubleFunction = toString = asInt ? v -> Integer.toString((int)Math.rint(v)) : Double::toString;
            if (outMinValue && outMaxValue) {
                return String.format("allowed range [%s, %s].", toString.apply(minValue), toString.apply(maxValue));
            }
            if (outMinValue) {
                return String.format("minimum allowed value %s", toString.apply(minValue));
            }
            if (outMaxValue) {
                return String.format("maximum allowed value %s", toString.apply(maxValue));
            }
            throw new ShouldNeverReachHereException("Unbounded range should never result in this exception");
        }
    }

    public static class BadArgumentValue
    extends CommandLineException {
        private static final long serialVersionUID = 0L;

        public BadArgumentValue(String arg, String value) {
            super(String.format("Argument %s has a bad value: %s", arg, value));
        }

        public BadArgumentValue(String arg, String value, String message) {
            super(String.format("Argument %s has a bad value: %s. %s", arg, value, message));
        }

        public BadArgumentValue(String message) {
            super(String.format("Illegal argument value: %s", message));
        }
    }

    public static class MissingArgument
    extends CommandLineException {
        private static final long serialVersionUID = 0L;

        public MissingArgument(String arg, String message) {
            super(String.format("Argument %s was missing: %s", arg, message));
        }
    }
}

