/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.argparser;

import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.broadinstitute.barclay.argparser.ArgumentDefinition;
import org.broadinstitute.barclay.argparser.CommandLineArgumentParser;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.PositionalArguments;
import org.broadinstitute.barclay.utils.Utils;

public class PositionalArgumentDefinition
extends ArgumentDefinition {
    private final PositionalArguments positionalArgumentsAnnotation;
    private static final String POSITIONAL_ARGUMENTS_NAME = "Positional Argument";

    public PositionalArgumentDefinition(PositionalArguments positionalArgumentsAnnotation, Object containingObject, Field argField) {
        super(containingObject, argField);
        Utils.nonNull(positionalArgumentsAnnotation);
        Utils.nonNull(containingObject);
        this.positionalArgumentsAnnotation = positionalArgumentsAnnotation;
        if (!PositionalArgumentDefinition.isCollectionField(argField)) {
            throw new CommandLineException.CommandLineParserInternalException("@PositionalArguments must be applied to a Collection");
        }
        if (positionalArgumentsAnnotation.minElements() > positionalArgumentsAnnotation.maxElements()) {
            throw new CommandLineException.CommandLineParserInternalException("In @PositionalArguments, minElements cannot be > maxElements");
        }
        this.intializeCollection("@PositionalArguments");
    }

    @Override
    public String getCommandLineDisplayString() {
        List<String> positionalArgs;
        try {
            positionalArgs = this.getOriginalCommandLineValues() == null ? (Collection)this.getUnderlyingField().get(this.getContainingObject()) : this.getOriginalCommandLineValues();
        }
        catch (IllegalAccessException e) {
            throw new CommandLineException.ShouldNeverReachHereException("setAccessible(true) was called", e);
        }
        return positionalArgs.stream().map(Object::toString).collect(Collectors.joining(" "));
    }

    public PositionalArguments getPositionalArgumentsAnnotation() {
        return this.positionalArgumentsAnnotation;
    }

    @Override
    public void setArgumentValues(CommandLineArgumentParser commandLineArgumentParser, PrintStream messageStream, List<String> stringValues) {
        List expandedValues = stringValues.stream().flatMap(s2 -> commandLineArgumentParser.expandFromExpansionFile(this, messageStream, (String)s2, stringValues).stream()).collect(Collectors.toList());
        for (String stringValue : expandedValues) {
            Collection c;
            Object value = this.constructFromString(stringValue, POSITIONAL_ARGUMENTS_NAME);
            try {
                c = (Collection)this.getUnderlyingField().get(this.getContainingObject());
            }
            catch (IllegalAccessException e) {
                throw new CommandLineException.ShouldNeverReachHereException(e);
            }
            if (c.size() >= this.positionalArgumentsAnnotation.maxElements()) {
                throw new CommandLineException(String.format("No more than %d positional arguments may be specified.", this.positionalArgumentsAnnotation.maxElements()));
            }
            c.add(value);
        }
    }

    @Override
    public void validateValues(CommandLineArgumentParser commandLineArgumentParser) {
        try {
            Collection c = (Collection)this.getUnderlyingField().get(this.getContainingObject());
            if (c.size() < this.positionalArgumentsAnnotation.minElements()) {
                throw new CommandLineException.MissingArgument(POSITIONAL_ARGUMENTS_NAME, String.format("At least %d positional arguments must be specified.", this.positionalArgumentsAnnotation.minElements()));
            }
        }
        catch (IllegalAccessException e) {
            throw new CommandLineException.ShouldNeverReachHereException("Should never happen", e);
        }
    }

    @Override
    public String getDocString() {
        return this.positionalArgumentsAnnotation.doc();
    }

    public String getArgumentUsage(int argumentColumnWidth, int descriptionColumnWidth) {
        StringBuilder sb = new StringBuilder();
        sb.append("--").append("POSITIONAL (must be first)");
        sb.append(String.format(" <%s>", this.getUnderlyingFieldClass().getSimpleName()));
        int labelLength = sb.toString().length();
        int numSpaces = argumentColumnWidth - labelLength;
        if (labelLength > argumentColumnWidth) {
            sb.append("\n");
            numSpaces = argumentColumnWidth;
        }
        Utils.printSpaces(sb, numSpaces);
        sb.append(this.getFormattedDescription(this.getArgumentDescription(), argumentColumnWidth, descriptionColumnWidth));
        sb.append("\n");
        return sb.toString();
    }

    private String getArgumentDescription() {
        StringBuilder sb = new StringBuilder();
        if (!this.getDocString().isEmpty()) {
            sb.append(this.getDocString());
            sb.append("  ");
        }
        if (this.isCollection()) {
            sb.append("This argument must be specified at least once. ");
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PositionalArgumentDefinition that = (PositionalArgumentDefinition)o;
        return this.getPositionalArgumentsAnnotation().equals(that.getPositionalArgumentsAnnotation());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getPositionalArgumentsAnnotation().hashCode();
        return result;
    }

    public String toString() {
        return POSITIONAL_ARGUMENTS_NAME + this.positionalArgumentsAnnotation;
    }
}

