/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.barclay.help.BarclayDocletOption;
import org.broadinstitute.barclay.help.DefaultDocWorkUnitHandler;
import org.broadinstitute.barclay.help.DocException;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.barclay.help.GSONWorkUnit;
import org.broadinstitute.barclay.help.scanners.JavaLanguageModelScanners;
import org.broadinstitute.barclay.utils.JVMUtils;

public class HelpDoclet
implements Doclet {
    static final File DEFAULT_SETTINGS_DIR = new File("settings/helpTemplates");
    static final String DEFAULT_SETTINGS_CLASSPATH = "/org/broadinstitute/barclay/helpTemplates";
    static final File DEFAULT_DESTINATION_DIR = new File("barclaydocs");
    static final String DEFAULT_OUTPUT_FILE_EXTENSION = "html";
    protected File settingsDir = DEFAULT_SETTINGS_DIR;
    protected boolean isSettingsDirSet = false;
    protected File destinationDir = DEFAULT_DESTINATION_DIR;
    protected String outputFileExtension = "html";
    protected String indexFileExtension = "html";
    protected String buildTimestamp = "[no timestamp available]";
    protected String absoluteVersion = "[no version available]";
    protected boolean showHiddenFeatures = false;
    protected boolean useDefaultTemplates = false;
    private DocletEnvironment docletEnv;
    protected Set<DocWorkUnit> workUnits = new LinkedHashSet<DocWorkUnit>();
    private Reporter reporter;

    @Override
    public void init(Locale locale, Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean run(DocletEnvironment docEnv) {
        if (this.useDefaultTemplates && this.isSettingsDirSet || !this.useDefaultTemplates && !this.isSettingsDirSet) {
            throw new RuntimeException("ERROR: must specify only ONE of: -use-default-templates , -settings-dir");
        }
        this.docletEnv = docEnv;
        if (!this.useDefaultTemplates) {
            this.validateSettingsDir();
        }
        this.validateDocletStartingState();
        this.processDocs(docEnv);
        return true;
    }

    @Override
    public Set<? extends Doclet.Option> getSupportedOptions() {
        return new LinkedHashSet<Doclet.Option>(){
            {
                this.add(new BarclayDocletOption.SimpleStandardOption("-d"){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        HelpDoclet.this.destinationDir = new File(arguments.get(0));
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption("-windowtitle"){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        return true;
                    }
                });
                this.add(new BarclayDocletOption.SimpleStandardOption("-doctitle"){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        return true;
                    }
                });
                this.add(new BarclayDocletOption(Arrays.asList("-quiet"), "quiet", 0, Doclet.Option.Kind.STANDARD, null){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        return true;
                    }
                });
                this.add(new BarclayDocletOption(Arrays.asList("-settings-dir"), "settings dir", 1, Doclet.Option.Kind.STANDARD, "<string>"){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        HelpDoclet.this.settingsDir = new File(arguments.get(0));
                        HelpDoclet.this.isSettingsDirSet = true;
                        return true;
                    }
                });
                this.add(new BarclayDocletOption(Arrays.asList("-build-timestamp"), "build timestamp", 1, Doclet.Option.Kind.OTHER, "<string>"){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        HelpDoclet.this.buildTimestamp = arguments.get(0);
                        return true;
                    }
                });
                this.add(new BarclayDocletOption(Arrays.asList("-absolute-version"), "absolute version", 1, Doclet.Option.Kind.OTHER, "<string>"){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        HelpDoclet.this.absoluteVersion = arguments.get(0);
                        return true;
                    }
                });
                this.add(new BarclayDocletOption(Arrays.asList("-output-file-extension"), "output file extension", 1, Doclet.Option.Kind.OTHER, "<string>"){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        HelpDoclet.this.outputFileExtension = arguments.get(0);
                        return true;
                    }
                });
                this.add(new BarclayDocletOption(Arrays.asList("-index-file-extension"), "index file extension", 1, Doclet.Option.Kind.OTHER, "<string>"){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        HelpDoclet.this.indexFileExtension = arguments.get(0);
                        return true;
                    }
                });
                this.add(new BarclayDocletOption(Arrays.asList("-hidden-version"), "hidden features", 0, Doclet.Option.Kind.OTHER, null){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        HelpDoclet.this.showHiddenFeatures = true;
                        return true;
                    }
                });
                this.add(new BarclayDocletOption(Arrays.asList("-use-default-templates"), "use default templates", 0, Doclet.Option.Kind.OTHER, null){

                    @Override
                    public boolean process(String option, List<String> arguments) {
                        HelpDoclet.this.useDefaultTemplates = true;
                        return true;
                    }
                });
            }
        };
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_17;
    }

    private void validateSettingsDir() {
        if (!this.settingsDir.exists()) {
            throw new RuntimeException("-settings-dir : " + this.settingsDir.getPath() + " does not exist!");
        }
        if (!this.settingsDir.isDirectory()) {
            throw new RuntimeException("-settings-dir : " + this.settingsDir.getPath() + " is not a directory!");
        }
    }

    protected void validateDocletStartingState() {
    }

    private void processDocs(DocletEnvironment docletEnv) {
        this.docletEnv = docletEnv;
        this.workUnits = JavaLanguageModelScanners.getWorkUnits(this, docletEnv, this.reporter, docletEnv.getIncludedElements());
        LinkedHashSet uniqueGroups = new LinkedHashSet();
        ArrayList<Map<String, String>> featureMaps = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> groupMaps = new ArrayList<Map<String, String>>();
        this.workUnits.stream().forEach(workUnit -> {
            featureMaps.add(this.indexDataMap((DocWorkUnit)workUnit));
            if (!uniqueGroups.contains(workUnit.getGroupName())) {
                uniqueGroups.add(workUnit.getGroupName());
                groupMaps.add(this.getGroupMap((DocWorkUnit)workUnit));
            }
        });
        this.workUnits.stream().forEach(workUnit -> workUnit.processDoc(featureMaps, groupMaps));
        this.emitOutputFromTemplates(groupMaps, featureMaps);
    }

    public DocletEnvironment getDocletEnv() {
        return this.docletEnv;
    }

    public String getBuildTimeStamp() {
        return this.buildTimestamp;
    }

    public String getBuildVersion() {
        return this.absoluteVersion;
    }

    public boolean showHiddenFeatures() {
        return this.showHiddenFeatures;
    }

    public String getOutputFileExtension() {
        return this.outputFileExtension;
    }

    public String getIndexFileExtension() {
        return this.indexFileExtension;
    }

    public String getIndexTemplateName() {
        return "generic.index.html.ftl";
    }

    public String getIndexBaseFileName() {
        return "index";
    }

    public File getDestinationDir() {
        return this.destinationDir;
    }

    public boolean includeInDocs(DocumentedFeature documentedFeature, Class<?> clazz) {
        boolean hidden = !this.showHiddenFeatures() && clazz.isAnnotationPresent(Hidden.class);
        return !hidden && JVMUtils.isConcrete(clazz);
    }

    private void emitOutputFromTemplates(List<Map<String, String>> groupMaps, List<Map<String, String>> featureMaps) {
        try {
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
            cfg.setObjectWrapper(new DefaultObjectWrapper(Configuration.VERSION_2_3_23));
            TemplateLoader templateLoader = this.useDefaultTemplates ? new ClassTemplateLoader(this.getClass(), DEFAULT_SETTINGS_CLASSPATH) : new FileTemplateLoader(new File(this.settingsDir.getPath()));
            cfg.setTemplateLoader(templateLoader);
            this.workUnits.stream().forEach(workUnit -> this.processWorkUnitTemplate(cfg, (DocWorkUnit)workUnit, groupMaps, featureMaps));
            this.processIndexTemplate(cfg, new ArrayList<DocWorkUnit>(this.workUnits), groupMaps);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("FileNotFoundException processing javadoc template", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IOException processing javadoc template", e);
        }
    }

    public DocWorkUnit createWorkUnit(Element classElement, Class<?> clazz, DocumentedFeature documentedFeature) {
        return new DocWorkUnit(new DefaultDocWorkUnitHandler(this), classElement, clazz, documentedFeature);
    }

    protected void processIndexTemplate(Configuration cfg, List<DocWorkUnit> workUnitList, List<Map<String, String>> groupMaps) throws IOException {
        Template template = cfg.getTemplate(this.getIndexTemplateName());
        File indexFile = new File(this.getDestinationDir(), this.getIndexBaseFileName() + "." + this.getIndexFileExtension());
        try (FileOutputStream fileOutStream = new FileOutputStream(indexFile);
             OutputStreamWriter outWriter = new OutputStreamWriter(fileOutStream);){
            template.process(this.groupIndexMap(workUnitList, groupMaps), outWriter);
        }
        catch (TemplateException e) {
            throw new DocException("Freemarker Template Exception during documentation index creation", e);
        }
    }

    protected Map<String, Object> groupIndexMap(List<DocWorkUnit> workUnitList, List<Map<String, String>> groupMaps) {
        HashMap<String, Object> root = new HashMap<String, Object>();
        Collections.sort(workUnitList);
        ArrayList data = new ArrayList();
        workUnitList.stream().forEach(workUnit -> data.add(this.indexDataMap((DocWorkUnit)workUnit)));
        root.put("data", data);
        root.put("groups", groupMaps);
        root.put("timestamp", this.getBuildTimeStamp());
        root.put("version", this.getBuildVersion());
        return root;
    }

    protected Map<String, String> getGroupMap(DocWorkUnit workUnit) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("id", this.getGroupIdFromName(workUnit.getGroupName()));
        propertyMap.put("name", workUnit.getGroupName());
        propertyMap.put("summary", workUnit.getGroupSummary());
        return propertyMap;
    }

    private String getGroupIdFromName(String groupName) {
        return groupName.replaceAll("\\W", "");
    }

    public Map<String, String> indexDataMap(DocWorkUnit workUnit) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("name", workUnit.getName());
        propertyMap.put("summary", workUnit.getSummary());
        propertyMap.put("filename", workUnit.getTargetFileName());
        propertyMap.put("group", workUnit.getGroupName());
        propertyMap.put("beta", Boolean.toString(workUnit.isBetaFeature()));
        propertyMap.put("experimental", Boolean.toString(workUnit.isExperimentalFeature()));
        propertyMap.put("deprecated", Boolean.toString(workUnit.isDeprecatedFeature()));
        return propertyMap;
    }

    public final DocWorkUnit findWorkUnitForClass(Class<?> c) {
        for (DocWorkUnit workUnit : this.workUnits) {
            if (!workUnit.getClazz().equals(c)) continue;
            return workUnit;
        }
        return null;
    }

    protected void processWorkUnitTemplate(Configuration cfg, DocWorkUnit workUnit, List<Map<String, String>> indexByGroupMaps, List<Map<String, String>> featureMaps) {
        try {
            Template template = cfg.getTemplate(workUnit.getTemplateName());
            File outputPath = new File(this.getDestinationDir(), workUnit.getTargetFileName());
            try (OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(outputPath));){
                template.process(workUnit.getRootMap(), out);
            }
        }
        catch (IOException e) {
            throw new DocException("IOException during documentation creation", e);
        }
        catch (TemplateException e) {
            throw new DocException("TemplateException during documentation creation", e);
        }
        GSONWorkUnit gsonworkunit = this.createGSONWorkUnit(workUnit, indexByGroupMaps, featureMaps);
        File outputPathForJSON = new File(this.getDestinationDir(), workUnit.getJSONFileName());
        try (BufferedWriter jsonWriter = new BufferedWriter(new FileWriter(outputPathForJSON));){
            Gson gson = new GsonBuilder().serializeSpecialFloatingPointValues().setPrettyPrinting().create();
            String json = gson.toJson(gsonworkunit);
            jsonWriter.write(json);
        }
        catch (IOException e) {
            throw new DocException("Failed to create JSON entry", e);
        }
    }

    protected GSONWorkUnit createGSONWorkUnit(DocWorkUnit workUnit, List<Map<String, String>> indexByGroupMaps, List<Map<String, String>> featureMaps) {
        return new GSONWorkUnit(workUnit);
    }
}

