/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.http.nio;

import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.broadinstitute.http.nio.HttpFileSystem;
import org.broadinstitute.http.nio.HttpFileSystemProviderSettings;
import org.broadinstitute.http.nio.HttpPath;
import org.broadinstitute.http.nio.HttpSeekableByteChannel;
import org.broadinstitute.http.nio.utils.HttpUtils;
import org.broadinstitute.http.nio.utils.Utils;

abstract class HttpAbstractFileSystemProvider
extends FileSystemProvider {
    private static HttpFileSystemProviderSettings settings = HttpFileSystemProviderSettings.DEFAULT_SETTINGS;
    private final Map<String, HttpFileSystem> fileSystems = new ConcurrentHashMap<String, HttpFileSystem>();

    HttpAbstractFileSystemProvider() {
    }

    @Override
    public abstract String getScheme();

    private URI checkUri(URI uri) {
        Utils.nonNull(uri, () -> "null URI");
        Utils.nonNull(uri.getAuthority(), () -> String.format("%s requires URI with authority: invalid %s", this, uri));
        if (!this.getScheme().equalsIgnoreCase(uri.getScheme())) {
            throw new ProviderMismatchException(String.format("Invalid scheme for %s: %s", this, uri.getScheme()));
        }
        return uri;
    }

    @Override
    public final HttpFileSystem newFileSystem(URI uri, Map<String, ?> env) {
        this.checkUri(uri);
        if (this.fileSystems.containsKey(uri.getAuthority())) {
            throw new FileSystemAlreadyExistsException("URI: " + uri);
        }
        return this.fileSystems.computeIfAbsent(uri.getAuthority(), auth -> new HttpFileSystem(this, (String)auth));
    }

    @Override
    public final HttpFileSystem getFileSystem(URI uri) {
        HttpFileSystem fs = this.fileSystems.get(this.checkUri(uri).getAuthority());
        if (fs == null) {
            throw new FileSystemNotFoundException("URI: " + uri);
        }
        return fs;
    }

    @Override
    public final HttpPath getPath(URI uri) {
        this.checkUri(uri);
        return this.fileSystems.computeIfAbsent(uri.getAuthority(), auth -> new HttpFileSystem(this, (String)auth)).getPath(uri);
    }

    @Override
    public final SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        Utils.nonNull(path, () -> "null path");
        Utils.nonNull(options, () -> "null options");
        if (options.isEmpty() || options.size() == 1 && options.contains(StandardOpenOption.READ)) {
            URI uri = path.toUri();
            this.checkUri(uri);
            return new HttpSeekableByteChannel(uri, settings, 0L);
        }
        throw new UnsupportedOperationException(String.format("Only %s is supported for %s, but %s options(s) are provided", StandardOpenOption.READ, this, options));
    }

    @Override
    public final DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public final void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " is read-only: cannot create directory");
    }

    @Override
    public final void delete(Path path) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " is read-only: cannot delete directory");
    }

    @Override
    public final void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public final void move(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " is read-only: cannot move paths");
    }

    @Override
    public final boolean isSameFile(Path path, Path path2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public final boolean isHidden(Path path) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public final FileStore getFileStore(Path path) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public final void checkAccess(Path path, AccessMode ... modes) throws IOException {
        Utils.nonNull(path, () -> "null path");
        URI uri = this.checkUri(path.toUri());
        if (!HttpUtils.exists(uri, settings)) {
            throw new NoSuchFileException(uri.toString());
        }
        for (AccessMode access : modes) {
            if (Objects.requireNonNull(access) == AccessMode.READ) continue;
            throw new UnsupportedOperationException("Unsupported access mode: " + access);
        }
    }

    @Override
    public final <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public final <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type.equals(HttpBasicFileAttributes.class) || type.equals(BasicFileAttributes.class)) {
            return (A)new HttpBasicFileAttributes();
        }
        throw new UnsupportedOperationException("Can't provide attributes of the given type: " + type.getCanonicalName());
    }

    @Override
    public final Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public final void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " is read-only: cannot set attributes to paths");
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static synchronized HttpFileSystemProviderSettings getSettings() {
        return settings;
    }

    public static synchronized void setSettings(HttpFileSystemProviderSettings settings) {
        HttpAbstractFileSystemProvider.settings = settings;
    }

    private static class HttpBasicFileAttributes
    implements BasicFileAttributes {
        private HttpBasicFileAttributes() {
        }

        @Override
        public FileTime lastModifiedTime() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public FileTime lastAccessTime() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public FileTime creationTime() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public boolean isRegularFile() {
            return true;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            throw new UnsupportedOperationException("Not implemented");
        }

        @Override
        public Object fileKey() {
            throw new UnsupportedOperationException("Not implemented");
        }
    }
}

