/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.QualityUtil;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.StringUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.analysis.GcBiasCollectorArgs;
import picard.analysis.GcBiasDetailMetrics;
import picard.analysis.GcBiasSummaryMetrics;
import picard.analysis.GcBiasUtils;
import picard.analysis.MetricAccumulationLevel;
import picard.metrics.GcBiasMetrics;
import picard.metrics.MultiLevelCollector;
import picard.metrics.PerUnitMetricCollector;

public class GcBiasMetricsCollector
extends MultiLevelCollector<GcBiasMetrics, Integer, GcBiasCollectorArgs> {
    private final int scanWindowSize;
    private final boolean bisulfite;
    private int[] windowsByGc = new int[101];
    private static final int BINS = 101;
    private boolean ignoreDuplicates;
    private byte[] gc = null;
    private int referenceIndex = -1;
    private byte[] refBases = null;
    private static final Log log = Log.getInstance(GcBiasMetricsCollector.class);

    public GcBiasMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, int[] windowsByGc, List<SAMReadGroupRecord> samRgRecords, int scanWindowSize, boolean bisulfite) {
        this(accumulationLevels, windowsByGc, samRgRecords, scanWindowSize, bisulfite, false);
    }

    public GcBiasMetricsCollector(Set<MetricAccumulationLevel> accumulationLevels, int[] windowsByGc, List<SAMReadGroupRecord> samRgRecords, int scanWindowSize, boolean bisulfite, boolean ignoreDuplicates) {
        this.scanWindowSize = scanWindowSize;
        this.bisulfite = bisulfite;
        this.windowsByGc = windowsByGc;
        this.ignoreDuplicates = ignoreDuplicates;
        this.setup(accumulationLevels, samRgRecords);
    }

    @Override
    protected GcBiasCollectorArgs makeArg(SAMRecord rec, ReferenceSequence ref) {
        return new GcBiasCollectorArgs(rec, ref);
    }

    @Override
    protected PerUnitMetricCollector<GcBiasMetrics, Integer, GcBiasCollectorArgs> makeChildCollector(String sample, String library, String readGroup) {
        return new PerUnitGcBiasMetricsCollector(sample, library, readGroup);
    }

    private double calculateGcNormCoverage(double meanReadsPerWindow, int[] readsByGc, int start, int end) {
        int windowsTotal = 0;
        double sum = 0.0;
        for (int i = start; i <= end; ++i) {
            if (this.windowsByGc[i] == 0) continue;
            sum += (double)readsByGc[i];
            windowsTotal += this.windowsByGc[i];
        }
        if (windowsTotal == 0) {
            return 0.0;
        }
        return sum / ((double)windowsTotal * meanReadsPerWindow);
    }

    private void calculateDropoutMetrics(Collection<GcBiasDetailMetrics> details, GcBiasSummaryMetrics summary) {
        double totalReads = 0.0;
        double totalWindows = 0.0;
        for (GcBiasDetailMetrics detail : details) {
            totalReads += (double)detail.READ_STARTS;
            totalWindows += (double)detail.WINDOWS;
        }
        double atDropout = 0.0;
        double gcDropout = 0.0;
        for (GcBiasDetailMetrics detail : details) {
            double relativeWindows = (double)detail.WINDOWS / totalWindows;
            double relativeReads = (double)detail.READ_STARTS / totalReads;
            double dropout = (relativeWindows - relativeReads) * 100.0;
            if (!(dropout > 0.0)) continue;
            if (detail.GC <= 50) {
                atDropout += dropout;
                continue;
            }
            gcDropout += dropout;
        }
        summary.AT_DROPOUT = atDropout;
        summary.GC_DROPOUT = gcDropout;
    }

    private void addRead(GcObject gcObj, SAMRecord rec, String group, byte[] gc, byte[] refBases) {
        byte windowGc;
        if (!rec.getReadPairedFlag() || rec.getFirstOfPairFlag()) {
            ++gcObj.totalClusters;
        }
        int pos = rec.getReadNegativeStrandFlag() ? rec.getAlignmentEnd() - this.scanWindowSize : rec.getAlignmentStart();
        ++gcObj.totalAlignedReads;
        if (pos > 0 && (windowGc = gc[pos]) >= 0) {
            byte by = windowGc;
            gcObj.readsByGc[by] = gcObj.readsByGc[by] + 1;
            byte by2 = windowGc;
            gcObj.basesByGc[by2] = gcObj.basesByGc[by2] + (long)rec.getReadLength();
            byte by3 = windowGc;
            gcObj.errorsByGc[by3] = gcObj.errorsByGc[by3] + (long)(SequenceUtil.countMismatches(rec, refBases, this.bisulfite) + SequenceUtil.countInsertedBases(rec) + SequenceUtil.countDeletedBases(rec));
        }
        if (gcObj.group == null) {
            gcObj.group = group;
        }
    }

    public class PerUnitGcBiasMetricsCollector
    implements PerUnitMetricCollector<GcBiasMetrics, Integer, GcBiasCollectorArgs> {
        private final Map<String, GcObject> gcData;
        private Map<String, GcObject> gcDataNonDups;
        private final String sample;
        private final String library;
        private final String readGroup;
        private static final String allReads = "All_Reads";
        static final String ACCUMULATION_LEVEL_ALL_READS = "All Reads";
        static final String ACCUMULATION_LEVEL_LIBRARY = "Library";
        static final String ACCUMULATION_LEVEL_SAMPLE = "Sample";
        static final String ACCUMULATION_LEVEL_READ_GROUP = "Read Group";
        static final String READS_USED_ALL = "ALL";
        static final String READS_USED_UNIQUE = "UNIQUE";
        private int logCounter;

        public PerUnitGcBiasMetricsCollector(String sample, String library, String readGroup) {
            this.sample = sample;
            this.library = library;
            this.readGroup = readGroup;
            this.gcData = this.prepareGcData();
            if (GcBiasMetricsCollector.this.ignoreDuplicates) {
                this.gcDataNonDups = this.prepareGcData();
            }
        }

        @Override
        public void acceptRecord(GcBiasCollectorArgs args) {
            SAMRecord rec = args.getRec();
            if (this.logCounter < 100 && rec.getReadBases().length == 0) {
                log.warn("Omitting read " + rec.getReadName() + " with '*' in SEQ field.");
                if (++this.logCounter == 100) {
                    log.warn("There are more than 100 reads with '*' in SEQ field in file.");
                }
                return;
            }
            if (!rec.getReadUnmappedFlag()) {
                if (GcBiasMetricsCollector.this.referenceIndex != rec.getReferenceIndex() || GcBiasMetricsCollector.this.gc == null) {
                    ReferenceSequence ref = args.getRef();
                    GcBiasMetricsCollector.this.refBases = ref.getBases();
                    StringUtil.toUpperCase(GcBiasMetricsCollector.this.refBases);
                    int refLength = GcBiasMetricsCollector.this.refBases.length;
                    int lastWindowStart = refLength - GcBiasMetricsCollector.this.scanWindowSize;
                    GcBiasMetricsCollector.this.gc = GcBiasUtils.calculateAllGcs(GcBiasMetricsCollector.this.refBases, lastWindowStart, GcBiasMetricsCollector.this.scanWindowSize);
                    GcBiasMetricsCollector.this.referenceIndex = rec.getReferenceIndex();
                }
                this.addReadToGcData(rec, this.gcData);
                if (GcBiasMetricsCollector.this.ignoreDuplicates && !rec.getDuplicateReadFlag()) {
                    this.addReadToGcData(rec, this.gcDataNonDups);
                }
            } else {
                this.updateTotalClusters(rec, this.gcData);
                if (GcBiasMetricsCollector.this.ignoreDuplicates && !rec.getDuplicateReadFlag()) {
                    this.updateTotalClusters(rec, this.gcDataNonDups);
                }
            }
        }

        @Override
        public void finish() {
        }

        @Override
        public void addMetricsToFile(MetricsFile<GcBiasMetrics, Integer> file) {
            this.addGcDataToFile(file, this.gcData, true);
            if (GcBiasMetricsCollector.this.ignoreDuplicates) {
                this.addGcDataToFile(file, this.gcDataNonDups, false);
            }
        }

        private void updateTotalClusters(SAMRecord rec, Map<String, GcObject> gcData) {
            for (Map.Entry<String, GcObject> entry : gcData.entrySet()) {
                GcObject gcCur = entry.getValue();
                if (rec.getReadPairedFlag() && !rec.getFirstOfPairFlag()) continue;
                ++gcCur.totalClusters;
            }
        }

        private Map<String, GcObject> prepareGcData() {
            HashMap<String, GcObject> gcData = new HashMap<String, GcObject>();
            String prefix = this.readGroup != null ? this.readGroup : (this.library != null ? this.library : (this.sample != null ? this.sample : allReads));
            gcData.put(prefix, new GcObject());
            return gcData;
        }

        private void addReadToGcData(SAMRecord rec, Map<String, GcObject> gcData) {
            String group;
            String type;
            if (this.readGroup != null) {
                type = this.readGroup;
                group = ACCUMULATION_LEVEL_READ_GROUP;
            } else if (this.library != null) {
                type = this.library;
                group = ACCUMULATION_LEVEL_LIBRARY;
            } else if (this.sample != null) {
                type = this.sample;
                group = ACCUMULATION_LEVEL_SAMPLE;
            } else {
                type = allReads;
                group = ACCUMULATION_LEVEL_ALL_READS;
            }
            GcBiasMetricsCollector.this.addRead(gcData.get(type), rec, group, GcBiasMetricsCollector.this.gc, GcBiasMetricsCollector.this.refBases);
        }

        private double sum(int[] values) {
            int length = values.length;
            double total = 0.0;
            for (int i = 0; i < length; ++i) {
                total += (double)values[i];
            }
            return total;
        }

        private void addGcDataToFile(MetricsFile<GcBiasMetrics, Integer> file, Map<String, GcObject> gcData, boolean includeDuplicates) {
            for (Map.Entry<String, GcObject> entry : gcData.entrySet()) {
                GcObject gcCur = entry.getValue();
                String gcType = entry.getKey();
                int[] readsByGc = gcCur.readsByGc;
                long[] errorsByGc = gcCur.errorsByGc;
                long[] basesByGc = gcCur.basesByGc;
                long totalClusters = gcCur.totalClusters;
                long totalAlignedReads = gcCur.totalAlignedReads;
                String group = gcCur.group;
                GcBiasMetrics metrics = new GcBiasMetrics();
                double totalWindows = this.sum(GcBiasMetricsCollector.this.windowsByGc);
                double totalReads = this.sum(readsByGc);
                double meanReadsPerWindow = totalReads / totalWindows;
                if (totalAlignedReads <= 0L) continue;
                for (int i = 0; i < GcBiasMetricsCollector.this.windowsByGc.length; ++i) {
                    GcBiasDetailMetrics detail = new GcBiasDetailMetrics();
                    detail.GC = i;
                    detail.WINDOWS = GcBiasMetricsCollector.this.windowsByGc[i];
                    detail.READ_STARTS = readsByGc[i];
                    if (errorsByGc[i] > 0L) {
                        detail.MEAN_BASE_QUALITY = QualityUtil.getPhredScoreFromObsAndErrors(basesByGc[i], errorsByGc[i]);
                    }
                    if (GcBiasMetricsCollector.this.windowsByGc[i] != 0) {
                        detail.NORMALIZED_COVERAGE = (double)detail.READ_STARTS / (double)detail.WINDOWS / meanReadsPerWindow;
                        detail.ERROR_BAR_WIDTH = Math.sqrt(detail.READ_STARTS) / (double)detail.WINDOWS / meanReadsPerWindow;
                    } else {
                        detail.NORMALIZED_COVERAGE = 0.0;
                        detail.ERROR_BAR_WIDTH = 0.0;
                    }
                    detail.ACCUMULATION_LEVEL = group;
                    if (group.equals(ACCUMULATION_LEVEL_READ_GROUP)) {
                        detail.READ_GROUP = gcType;
                    } else if (group.equals(ACCUMULATION_LEVEL_SAMPLE)) {
                        detail.SAMPLE = gcType;
                    } else if (group.equals(ACCUMULATION_LEVEL_LIBRARY)) {
                        detail.LIBRARY = gcType;
                    }
                    detail.READS_USED = includeDuplicates ? READS_USED_ALL : READS_USED_UNIQUE;
                    metrics.DETAILS.addMetric(detail);
                }
                GcBiasSummaryMetrics summary = new GcBiasSummaryMetrics();
                if (group.equals(ACCUMULATION_LEVEL_READ_GROUP)) {
                    summary.READ_GROUP = gcType;
                } else if (group.equals(ACCUMULATION_LEVEL_SAMPLE)) {
                    summary.SAMPLE = gcType;
                } else if (group.equals(ACCUMULATION_LEVEL_LIBRARY)) {
                    summary.LIBRARY = gcType;
                }
                summary.READS_USED = includeDuplicates ? READS_USED_ALL : READS_USED_UNIQUE;
                summary.ACCUMULATION_LEVEL = group;
                summary.WINDOW_SIZE = GcBiasMetricsCollector.this.scanWindowSize;
                summary.TOTAL_CLUSTERS = totalClusters;
                summary.ALIGNED_READS = totalAlignedReads;
                summary.GC_NC_0_19 = GcBiasMetricsCollector.this.calculateGcNormCoverage(meanReadsPerWindow, readsByGc, 0, 19);
                summary.GC_NC_20_39 = GcBiasMetricsCollector.this.calculateGcNormCoverage(meanReadsPerWindow, readsByGc, 20, 39);
                summary.GC_NC_40_59 = GcBiasMetricsCollector.this.calculateGcNormCoverage(meanReadsPerWindow, readsByGc, 40, 59);
                summary.GC_NC_60_79 = GcBiasMetricsCollector.this.calculateGcNormCoverage(meanReadsPerWindow, readsByGc, 60, 79);
                summary.GC_NC_80_100 = GcBiasMetricsCollector.this.calculateGcNormCoverage(meanReadsPerWindow, readsByGc, 80, 100);
                GcBiasMetricsCollector.this.calculateDropoutMetrics(metrics.DETAILS.getMetrics(), summary);
                metrics.SUMMARY = summary;
                file.addMetric(metrics);
            }
        }
    }

    class GcObject {
        long totalClusters = 0L;
        long totalAlignedReads = 0L;
        int[] readsByGc = new int[101];
        long[] basesByGc = new long[101];
        long[] errorsByGc = new long[101];
        String group = null;

        GcObject() {
        }
    }
}

