/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.directed;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequenceFile;
import htsjdk.samtools.reference.ReferenceSequenceFileFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Argument;
import picard.analysis.MetricAccumulationLevel;
import picard.analysis.TheoreticalSensitivity;
import picard.analysis.TheoreticalSensitivityMetrics;
import picard.analysis.directed.TargetMetricsCollector;
import picard.cmdline.CommandLineProgram;
import picard.metrics.MultiLevelCollector;
import picard.metrics.MultilevelMetrics;
import picard.util.SequenceDictionaryUtils;

public abstract class CollectTargetedMetrics<METRIC extends MultilevelMetrics, COLLECTOR extends TargetMetricsCollector<METRIC>>
extends CommandLineProgram {
    private final Log log = Log.getInstance(this.getClass());
    @Argument(shortName="TI", doc="An interval list file that contains the locations of the targets.", minElements=1)
    public List<File> TARGET_INTERVALS;
    @Argument(shortName="I", doc="An aligned SAM/BAM/CRAM file.")
    public File INPUT;
    @Argument(shortName="O", doc="The output file to write the metrics to.")
    public File OUTPUT;
    @Argument(shortName="LEVEL", doc="The level(s) at which to accumulate metrics.")
    public Set<MetricAccumulationLevel> METRIC_ACCUMULATION_LEVEL = CollectionUtil.makeSet(MetricAccumulationLevel.ALL_READS);
    @Argument(optional=true, doc="An optional file to output per target coverage information to.")
    public File PER_TARGET_COVERAGE;
    @Argument(optional=true, doc="An optional file to output per base coverage information to. The per-base file contains one line per target base and can grow very large. It is not recommended for use with large target sets.")
    public File PER_BASE_COVERAGE;
    @Argument(optional=true, doc="The maximum distance between a read and the nearest probe/bait/amplicon for the read to be considered 'near probe' and included in percent selected.")
    public int NEAR_DISTANCE = 250;
    @Argument(shortName="MQ", doc="Minimum mapping quality for a read to contribute coverage.")
    public int MINIMUM_MAPPING_QUALITY = 1;
    @Argument(shortName="Q", doc="Minimum base quality for a base to contribute coverage.")
    public int MINIMUM_BASE_QUALITY = 0;
    @Argument(doc="True if we are to clip overlapping reads, false otherwise.", optional=true)
    public boolean CLIP_OVERLAPPING_READS = false;
    @Argument(doc="If true count inserted bases as on target and deleted bases as covered by a read.")
    public boolean INCLUDE_INDELS = false;
    @Argument(shortName="covMax", doc="Parameter to set a max coverage limit for Theoretical Sensitivity calculations. Default is 200.", optional=true)
    public int COVERAGE_CAP = 200;
    @Argument(doc="Sample Size used for Theoretical Het Sensitivity sampling. Default is 10000.", optional=true)
    public int SAMPLE_SIZE = 10000;
    @Argument(doc="Output for Theoretical Sensitivity metrics where the allele fractions are provided by the ALLELE_FRACTION argument.", optional=true)
    public File THEORETICAL_SENSITIVITY_OUTPUT;
    @Argument(doc="Allele fraction for which to calculate theoretical sensitivity.", optional=true)
    public List<Double> ALLELE_FRACTION = new ArrayList<Double>(Arrays.asList(0.001, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.3, 0.5));

    protected abstract IntervalList getProbeIntervals();

    protected abstract String getProbeSetName();

    protected abstract COLLECTOR makeCollector(Set<MetricAccumulationLevel> var1, List<SAMReadGroupRecord> var2, ReferenceSequenceFile var3, File var4, File var5, IntervalList var6, IntervalList var7, String var8, int var9);

    @Override
    protected int doWork() {
        for (File targetInterval : this.TARGET_INTERVALS) {
            IOUtil.assertFileIsReadable(targetInterval);
        }
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        if (this.PER_TARGET_COVERAGE != null) {
            IOUtil.assertFileIsWritable(this.PER_TARGET_COVERAGE);
        }
        SamReader reader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        IntervalList targetIntervals = IntervalList.fromFiles(this.TARGET_INTERVALS);
        SequenceDictionaryUtils.assertSequenceDictionariesEqual(reader.getFileHeader().getSequenceDictionary(), this.INPUT.getAbsolutePath(), targetIntervals.getHeader().getSequenceDictionary(), "target intervals");
        SequenceDictionaryUtils.assertSequenceDictionariesEqual(reader.getFileHeader().getSequenceDictionary(), this.INPUT.getAbsolutePath(), this.getProbeIntervals().getHeader().getSequenceDictionary(), "probe intervals");
        ReferenceSequenceFile ref = null;
        if (this.REFERENCE_SEQUENCE != null) {
            IOUtil.assertFileIsReadable(this.REFERENCE_SEQUENCE);
            ref = ReferenceSequenceFileFactory.getReferenceSequenceFile(this.REFERENCE_SEQUENCE);
            SequenceDictionaryUtils.assertSequenceDictionariesEqual(reader.getFileHeader().getSequenceDictionary(), this.INPUT.getAbsolutePath(), ref.getSequenceDictionary(), this.REFERENCE_SEQUENCE.getAbsolutePath());
        }
        COLLECTOR collector = this.makeCollector(this.METRIC_ACCUMULATION_LEVEL, reader.getFileHeader().getReadGroups(), ref, this.PER_TARGET_COVERAGE, this.PER_BASE_COVERAGE, targetIntervals, this.getProbeIntervals(), this.getProbeSetName(), this.NEAR_DISTANCE);
        ProgressLogger progress = new ProgressLogger(this.log);
        for (SAMRecord record : reader) {
            ((MultiLevelCollector)collector).acceptRecord(record, null);
            progress.record(record);
        }
        MetricsFile metrics = this.getMetricsFile();
        ((MultiLevelCollector)collector).finish();
        ((MultiLevelCollector)collector).addAllLevelsToFile(metrics);
        metrics.write(this.OUTPUT);
        if (this.THEORETICAL_SENSITIVITY_OUTPUT != null) {
            MetricsFile theoreticalSensitivityMetrics = this.getMetricsFile();
            this.log.info("Calculating theoretical sentitivity at " + this.ALLELE_FRACTION.size() + " allele fractions.");
            List<TheoreticalSensitivityMetrics> tsm = TheoreticalSensitivity.calculateSensitivities(this.SAMPLE_SIZE, ((TargetMetricsCollector)collector).getDepthHistogram(), ((TargetMetricsCollector)collector).getBaseQualityHistogram(), this.ALLELE_FRACTION);
            theoreticalSensitivityMetrics.addAllMetrics(tsm);
            theoreticalSensitivityMetrics.write(this.THEORETICAL_SENSITIVITY_OUTPUT);
        }
        CloserUtil.close(reader);
        return 0;
    }

    static String renderProbeNameFromFile(File probeIntervalFile) {
        String name = probeIntervalFile.getName();
        int firstPeriodIndex = name.indexOf(46);
        if (firstPeriodIndex == -1) {
            return name;
        }
        return name.substring(0, firstPeriodIndex);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.PER_TARGET_COVERAGE != null && (this.METRIC_ACCUMULATION_LEVEL.size() != 1 || this.METRIC_ACCUMULATION_LEVEL.iterator().next() != MetricAccumulationLevel.ALL_READS)) {
            return new String[]{"PER_TARGET_COVERAGE can be specified only when METRIC_ACCUMULATION_LEVEL is set to ALL_READS."};
        }
        if (this.PER_TARGET_COVERAGE != null && this.REFERENCE_SEQUENCE == null) {
            return new String[]{"Must supply REFERENCE_SEQUENCE when supplying PER_TARGET_COVERAGE"};
        }
        return super.customCommandLineValidation();
    }
}

