/*
 * Decompiled with CFR 0.152.
 */
package picard.arrays;

import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.arrays.BafRegressMetrics;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.GenotypingArraysProgramGroup;

@CommandLineProgramProperties(summary="CreateBafRegressMetricsFile takes an output file as generated by the bafRegress tool and creates a picard metrics file. BAFRegress <a href='https://genome.sph.umich.edu/wiki/BAFRegress'>bafRegress</a> is a software that detects and estimates sample contamination using B allele frequency data from Illumina genotyping arrays using a regression model.<h4>Usage example:</h4><pre>java -jar picard.jar CreateBafRegressMetricsFile \\<br />      INPUT=bafRegress.output.txt \\<br />      OUTPUT=outputBaseName</pre>", oneLineSummary="Program to generate a picard metrics file from the output of the bafRegress tool.", programGroup=GenotypingArraysProgramGroup.class)
@DocumentedFeature
public class CreateBafRegressMetricsFile
extends CommandLineProgram {
    static final String USAGE_DETAILS = "CreateBafRegressMetricsFile takes an output file as generated by the bafRegress tool and creates a picard metrics file. BAFRegress <a href='https://genome.sph.umich.edu/wiki/BAFRegress'>bafRegress</a> is a software that detects and estimates sample contamination using B allele frequency data from Illumina genotyping arrays using a regression model.<h4>Usage example:</h4><pre>java -jar picard.jar CreateBafRegressMetricsFile \\<br />      INPUT=bafRegress.output.txt \\<br />      OUTPUT=outputBaseName</pre>";
    @Argument(shortName="I", doc="The output of bafRegress (typically captured stdout).")
    public File INPUT;
    @Argument(shortName="O", doc="Basename for the metrics file that will be written. Resulting file will be <OUTPUT>.bafregress_metrics")
    public File OUTPUT;
    public static final String FILE_EXTENSION = "bafregress_metrics";

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        File metricsFile = new File(String.valueOf(this.OUTPUT) + ".bafregress_metrics");
        IOUtil.assertFileIsWritable(metricsFile);
        MetricsFile bafRegressMetricsMetricsFile = this.getMetricsFile();
        try (BufferedReader br = new BufferedReader(new FileReader(this.INPUT));){
            String line = br.readLine();
            if (!line.equals("sample\testimate\tstderr\ttval\tpval\tcallrate\tNhom")) {
                throw new PicardException("Unrecognized header line: '" + line + "' in " + this.INPUT.getAbsolutePath());
            }
            while ((line = br.readLine()) != null) {
                String[] entries = line.split("\\s+");
                if (entries.length != 7) {
                    throw new IOException("Invalid number of entries (" + entries.length + ") in line: " + line);
                }
                BafRegressMetrics metrics = new BafRegressMetrics();
                metrics.SAMPLE = entries[0];
                metrics.ESTIMATE = Double.parseDouble(entries[1]);
                metrics.STDERR = Double.parseDouble(entries[2]);
                metrics.TVAL = Double.parseDouble(entries[3]);
                metrics.PVAL = Double.parseDouble(entries[4]);
                metrics.LOG10_PVAL = Math.log10(metrics.PVAL);
                metrics.CALL_RATE = Double.parseDouble(entries[5]);
                metrics.NHOM = Integer.parseInt(entries[6]);
                bafRegressMetricsMetricsFile.addMetric(metrics);
            }
            bafRegressMetricsMetricsFile.write(metricsFile);
        }
        catch (IOException e) {
            throw new PicardException("Error parsing bafRegress Output", e);
        }
        return 0;
    }
}

