/*
 * Decompiled with CFR 0.152.
 */
package picard.cmdline.argumentcollections;

import htsjdk.samtools.util.Log;
import java.io.File;
import java.nio.file.Path;
import picard.nio.PicardHtsPath;

public interface ReferenceArgumentCollection {
    public File getReferenceFile();

    default public Path getReferencePath() {
        return this.getHtsPath() == null ? null : this.getHtsPath().toPath();
    }

    default public PicardHtsPath getHtsPath() {
        return this.getReferenceFile() == null ? null : new PicardHtsPath(this.getReferenceFile());
    }

    public static File getFileSafe(PicardHtsPath picardPath, Log log) {
        if (picardPath == null) {
            return null;
        }
        if (picardPath.getScheme().equals("file")) {
            return picardPath.toPath().toFile();
        }
        log.warn(String.format("The reference specified by %s cannot be used as a local file object", picardPath.getRawInputString()));
        return new File(picardPath.getRawInputString());
    }
}

