/*
 * Decompiled with CFR 0.152.
 */
package picard.fastq;

import java.io.File;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;
import picard.fastq.SamToBfqWriter;

@CommandLineProgramProperties(summary="<p>Converts a BAM file into a BFQ (binary fastq formatted) file.</p><p>The BFQ format is the input format to some tools like Maq aligner.</p><h3>Input</h3><p>A single BAM file to convert</p><h3>Output</h3><p>One or two FASTQ files depending on whether the BAM file contains single- or paired-end sequencing data. You must indicate the output directory that will contain these files (<code>ANALYSIS_DIR</code>) and the output file name prefix (<code>OUTPUT_FILE_PREFIX</code>).</p><h3>Usage example:</h3><pre>java -jar picard.jar BamToBfq \\\n     I=input.bam \\\n     ANALYSIS_DIR=output_dir \\\n     OUTPUT_FILE_PREFIX=output_name \\\n     PAIRED_RUN=false</pre><hr />", oneLineSummary="Converts a BAM file into a BFQ (binary fastq formatted) file", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class BamToBfq
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Converts a BAM file into a BFQ (binary fastq formatted) file";
    static final String USAGE_DETAILS = "<p>The BFQ format is the input format to some tools like Maq aligner.</p><h3>Input</h3><p>A single BAM file to convert</p><h3>Output</h3><p>One or two FASTQ files depending on whether the BAM file contains single- or paired-end sequencing data. You must indicate the output directory that will contain these files (<code>ANALYSIS_DIR</code>) and the output file name prefix (<code>OUTPUT_FILE_PREFIX</code>).</p><h3>Usage example:</h3><pre>java -jar picard.jar BamToBfq \\\n     I=input.bam \\\n     ANALYSIS_DIR=output_dir \\\n     OUTPUT_FILE_PREFIX=output_name \\\n     PAIRED_RUN=false</pre><hr />";
    @Argument(doc="The BAM file to parse.", shortName="I")
    public File INPUT;
    @Argument(doc="The analysis directory for the binary output file. ")
    public File ANALYSIS_DIR;
    @Argument(doc="Flowcell barcode (e.g. 30PYMAAXX).  ", shortName="F", mutex={"OUTPUT_FILE_PREFIX"})
    public String FLOWCELL_BARCODE;
    @Argument(doc="Lane number. ", shortName="L", optional=true, mutex={"OUTPUT_FILE_PREFIX"})
    public Integer LANE;
    @Argument(doc="Prefix for all output files", mutex={"FLOWCELL_BARCODE", "LANE"})
    public String OUTPUT_FILE_PREFIX;
    @Argument(doc="Number of reads to align (null = all).", shortName="NUM", optional=true)
    public Integer READS_TO_ALIGN;
    @Argument(doc="Number of reads to break into individual groups for alignment", shortName="CHUNK")
    public Integer READ_CHUNK_SIZE = 2000000;
    @Argument(doc="Whether this is a paired-end run. ", shortName="PE")
    public Boolean PAIRED_RUN;
    @Argument(doc="Deprecated option; use READ_NAME_PREFIX instead", mutex={"READ_NAME_PREFIX"}, shortName="RB", optional=true)
    public String RUN_BARCODE;
    @Argument(doc="Prefix to be stripped off the beginning of all read names  (to make them short enough to run in Maq)", optional=true)
    public String READ_NAME_PREFIX;
    @Argument(doc="Whether to include non-PF reads", shortName="NONPF", optional=true)
    public Boolean INCLUDE_NON_PF_READS = false;
    @Argument(doc="Whether to clip adapters from the reads")
    public boolean CLIP_ADAPTERS = true;
    @Argument(doc="The number of bases from each read to write to the bfq file.  If this is non-null, then only the first BASES_TO_WRITE bases from each read will be written.", optional=true)
    public Integer BASES_TO_WRITE = null;

    @Override
    protected int doWork() {
        Object outputPrefix = this.ANALYSIS_DIR.getAbsolutePath();
        if (!((String)outputPrefix).endsWith("/")) {
            outputPrefix = (String)outputPrefix + "/";
        }
        outputPrefix = (String)outputPrefix + this.OUTPUT_FILE_PREFIX + ".";
        SamToBfqWriter writer = new SamToBfqWriter(this.INPUT, this.REFERENCE_SEQUENCE, (String)outputPrefix, this.READS_TO_ALIGN, this.READ_CHUNK_SIZE, this.PAIRED_RUN, this.READ_NAME_PREFIX, this.INCLUDE_NON_PF_READS, this.CLIP_ADAPTERS, this.BASES_TO_WRITE);
        writer.writeBfqFiles();
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.OUTPUT_FILE_PREFIX == null) {
            this.OUTPUT_FILE_PREFIX = this.FLOWCELL_BARCODE + "." + this.LANE;
        }
        if (this.READ_NAME_PREFIX == null) {
            this.READ_NAME_PREFIX = this.RUN_BARCODE + ":";
        }
        return null;
    }
}

