/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.FileNotFoundException;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.fingerprint.HaplotypeMap;

@CommandLineProgramProperties(summary="Convert Haplotype database file to vcf<h3>Examples</h3><pre>java -jar picard.jar ConvertHaplotypeDatabaseToVcf \\\n-I haplotype_database.txt \\\n-O haplotype_database.vcf.gz \\\n-R reference.fasta</pre>", oneLineSummary="Convert Haplotype database file to vcf", programGroup=DiagnosticsAndQCProgramGroup.class)
public class ConvertHaplotypeDatabaseToVcf
extends CommandLineProgram {
    @Argument(doc="Haplotype database to be converted to VCF.", shortName="I")
    public File INPUT;
    @Argument(doc="Where to write converted haplotype database VCF.", shortName="O")
    public File OUTPUT;

    @Override
    protected boolean requiresReference() {
        return true;
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        HaplotypeMap haplotypeMap = new HaplotypeMap(this.INPUT);
        try {
            haplotypeMap.writeAsVcf(this.OUTPUT, this.REFERENCE_SEQUENCE);
        }
        catch (FileNotFoundException ex) {
            throw new PicardException("Problem writing haplotype map to " + String.valueOf(this.OUTPUT), ex);
        }
        return 0;
    }
}

