/*
 * Decompiled with CFR 0.152.
 */
package picard.flow;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import picard.PicardException;
import picard.flow.FlowReadGroupInfo;

public class FlowBasedKeyCodec {
    private static final Map<String, FlowReadGroupInfo> readGroupInfo = new LinkedHashMap<String, FlowReadGroupInfo>();

    public static int[] baseArrayToKey(byte[] bases, String flowOrder) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        byte[] flowOrderBytes = flowOrder.getBytes();
        int loc = 0;
        int flowNumber = 0;
        int period = flowOrderBytes.length;
        int periodGuard = 0;
        while (loc < bases.length) {
            byte flowBase = flowOrderBytes[flowNumber % period];
            if (bases[loc] != flowBase && bases[loc] != 78) {
                result.add(0);
                if (++periodGuard > period) {
                    throw new PicardException("baseArrayToKey periodGuard tripped, on " + new String(bases) + ", flowOrder: " + flowOrder + " This probably indicates the presence of a base (value) in the sequence that is not included in the provided flow order");
                }
            } else {
                int count = 0;
                while (loc < bases.length && (bases[loc] == flowBase || bases[loc] == 78)) {
                    ++loc;
                    ++count;
                }
                result.add(count);
                periodGuard = 0;
            }
            ++flowNumber;
        }
        int[] ret = new int[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            ret[i] = (Integer)result.get(i);
        }
        return ret;
    }

    public static int[] getKeyToBase(int[] key) {
        int[] result = new int[key.length];
        result[0] = -1;
        for (int i = 1; i < result.length; ++i) {
            result[i] = result[i - 1] + key[i - 1];
        }
        return result;
    }

    public static byte[] getFlowToBase(String flowOrder, int expectedLength) {
        byte[] result = new byte[expectedLength];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)flowOrder.charAt(i % flowOrder.length());
        }
        return result;
    }

    public static String keyAsString(int[] ints) {
        StringBuilder sb = new StringBuilder();
        for (int i : ints) {
            sb.append((char)(i < 10 ? 48 + i : 65 + i - 10));
        }
        return sb.toString();
    }

    @VisibleForTesting
    public static byte[] baseArrayToKeySpace(byte[] bases, int keyLength, byte[] baseSpacedArrayToConvert, byte defaultQual, String flowOrder) {
        if (bases.length != baseSpacedArrayToConvert.length) {
            throw new IllegalArgumentException("Read and qual arrays do not match");
        }
        byte[] result = new byte[keyLength];
        byte[] flowOrderBytes = flowOrder.getBytes();
        int loc = 0;
        int flowNumber = 0;
        int lastQual = defaultQual;
        int period = flowOrderBytes.length;
        while (loc < bases.length) {
            byte flowBase = flowOrderBytes[flowNumber % period];
            if (bases[loc] != flowBase && bases[loc] != 78) {
                result[flowNumber] = lastQual;
            } else {
                int qual = 127;
                while (loc < bases.length && (bases[loc] == flowBase || bases[loc] == 78)) {
                    qual = (byte)Math.min(baseSpacedArrayToConvert[loc], qual);
                    ++loc;
                }
                result[flowNumber] = qual;
                lastQual = qual;
            }
            ++flowNumber;
        }
        return result;
    }

    public static synchronized FlowReadGroupInfo getReadGroupInfo(SAMFileHeader hdr, SAMRecord read) {
        String name = read.getReadGroup().getReadGroupId();
        FlowReadGroupInfo info = readGroupInfo.get(name);
        if (info == null) {
            info = new FlowReadGroupInfo(hdr.getReadGroup(name));
            readGroupInfo.put(name, info);
        }
        return info;
    }

    public static int[] findLeftClipping(int baseClipping, int[] flow2base, int[] key) {
        int[] result = new int[2];
        if (baseClipping == 0) {
            return result;
        }
        int stopClip = 0;
        for (int i = 0; i < flow2base.length; ++i) {
            if (flow2base[i] + key[i] < baseClipping) continue;
            stopClip = i;
            break;
        }
        int hmerClipped = baseClipping - flow2base[stopClip] - 1;
        result[0] = stopClip;
        result[1] = hmerClipped;
        return result;
    }

    public static int[] findRightClipping(int baseClipping, int[] rFlow2Base, int[] rKey) {
        int[] result = new int[2];
        if (baseClipping == 0) {
            return result;
        }
        int stopClip = 0;
        for (int i = 0; i < rFlow2Base.length; ++i) {
            if (rFlow2Base[i] + rKey[i] < baseClipping) continue;
            stopClip = i;
            break;
        }
        int hmerClipped = baseClipping - rFlow2Base[stopClip] - 1;
        result[0] = stopClip;
        result[1] = hmerClipped;
        return result;
    }
}

