/*
 * Decompiled with CFR 0.152.
 */
package picard.flow;

import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMUtils;
import picard.PicardException;
import picard.flow.FlowBasedArgumentCollection;
import picard.flow.FlowBasedKeyCodec;

public class FlowBasedRead {
    public static final int MAX_CLASS = 12;
    private final double MINIMAL_CALL_PROB = 0.1;
    private static final String FLOW_MATRIX_TAG_NAME = "tp";
    private static final String FLOW_MATRIX_T0_TAG_NAME = "t0";
    public static final String MAX_CLASS_READ_GROUP_TAG = "mc";
    private SAMRecord samRecord;
    private int[] key;
    private int maxHmer;
    private double perHmerMinErrorProbability;
    private double[][] flowMatrix;
    private boolean validKey;
    private final FlowBasedArgumentCollection fbargs;

    public FlowBasedRead(SAMRecord samRecord, String flowOrder, int maxHmer, FlowBasedArgumentCollection fbargs) {
        this.fbargs = fbargs;
        this.maxHmer = maxHmer;
        this.samRecord = samRecord;
        if (!samRecord.hasAttribute(FLOW_MATRIX_TAG_NAME)) {
            throw new PicardException("read missing flow matrix attribute: tp");
        }
        this.readFlowMatrix(flowOrder);
        if (samRecord.getReadUnmappedFlag() || samRecord.getCigar().getFirstCigarElement().getOperator() == CigarOperator.HARD_CLIP && samRecord.getCigar().getFirstCigarElement().getLength() > 0) {
            this.spreadFlowLengthProbsAcrossCountsAtFlow(FlowBasedRead.findFirstNonZero(this.key));
        }
        if (samRecord.getReadUnmappedFlag() || samRecord.getCigar().getLastCigarElement().getOperator() == CigarOperator.HARD_CLIP && samRecord.getCigar().getLastCigarElement().getLength() > 0) {
            this.spreadFlowLengthProbsAcrossCountsAtFlow(FlowBasedRead.findLastNonZero(this.key));
        }
        this.validateSequence();
    }

    private void spreadFlowLengthProbsAcrossCountsAtFlow(int flowToSpread) {
        if (flowToSpread < 0) {
            return;
        }
        int call = this.key[flowToSpread];
        if (call == 0) {
            throw new IllegalStateException("Boundary key value should not be zero for the spreading");
        }
        int numberToFill = this.maxHmer - call + 1;
        double total = 0.0;
        for (int i = call; i < this.maxHmer + 1; ++i) {
            total += this.flowMatrix[i][flowToSpread];
        }
        double fillProb = Math.max(total / (double)numberToFill, this.perHmerMinErrorProbability);
        for (int i = call; i < this.maxHmer + 1; ++i) {
            this.flowMatrix[i][flowToSpread] = fillProb;
        }
    }

    private void readFlowMatrix(String _flowOrder) {
        double totalMinErrorProbability = this.fbargs.fillingValue == 0.0 ? this.estimateFillingValue() : this.fbargs.fillingValue;
        this.perHmerMinErrorProbability = totalMinErrorProbability / (double)this.getMaxHmer();
        this.key = FlowBasedKeyCodec.baseArrayToKey(this.samRecord.getReadBases(), _flowOrder);
        this.flowMatrix = new double[this.maxHmer + 1][this.key.length];
        for (int i = 0; i < this.maxHmer + 1; ++i) {
            for (int j = 0; j < this.key.length; ++j) {
                this.flowMatrix[i][j] = this.perHmerMinErrorProbability;
            }
        }
        byte[] quals = this.samRecord.getBaseQualities();
        byte[] tp = this.samRecord.getSignedByteArrayAttribute(FLOW_MATRIX_TAG_NAME);
        boolean specialTreatmentForZeroCalls = false;
        byte[] t0 = SAMUtils.fastqToPhred(this.samRecord.getStringAttribute(FLOW_MATRIX_T0_TAG_NAME));
        double[] t0probs = new double[quals.length];
        if (t0 != null && !this.fbargs.ignoreT0Tag) {
            specialTreatmentForZeroCalls = true;
            if (t0.length != tp.length) {
                throw new PicardException("Illegal read len(t0)!=len(qual): " + this.samRecord.getReadName());
            }
        }
        double[] probs = new double[quals.length];
        for (int i = 0; i < quals.length; ++i) {
            double p;
            double q = quals[i];
            probs[i] = p = Math.pow(10.0, -q / 10.0);
            if (!specialTreatmentForZeroCalls) continue;
            double qq = t0[i];
            t0probs[i] = Math.pow(10.0, -qq / 10.0);
        }
        int qualOfs = 0;
        for (int i = 0; i < this.key.length; ++i) {
            double callProb;
            int run = this.key[i];
            if (run > 0) {
                this.parseSingleHmer(probs, tp, i, run, qualOfs);
            }
            if (run == 0 && specialTreatmentForZeroCalls) {
                this.parseZeroQuals(t0probs, i, qualOfs, totalMinErrorProbability);
            }
            double totalErrorProb = 0.0;
            for (int k = 0; k < this.maxHmer; ++k) {
                totalErrorProb += this.flowMatrix[k][i];
            }
            this.flowMatrix[Math.min((int)run, (int)this.maxHmer)][i] = callProb = Math.max(0.1, 1.0 - totalErrorProb);
            qualOfs += run;
        }
        this.applyFilteringFlowMatrix();
    }

    private void parseSingleHmer(double[] probs, byte[] tp, int flowIdx, int flowCall, int qualOfs) {
        for (int i = qualOfs; i < qualOfs + flowCall; ++i) {
            if (tp[i] == 0) continue;
            int loc = Math.max(Math.min(flowCall + tp[i], this.maxHmer), 0);
            if (this.flowMatrix[loc][flowIdx] == this.perHmerMinErrorProbability) {
                this.flowMatrix[loc][flowIdx] = probs[i];
                continue;
            }
            double[] dArray = this.flowMatrix[loc];
            int n = flowIdx;
            dArray[n] = dArray[n] + probs[i];
        }
    }

    private void parseZeroQuals(double[] probs, int flowIdx, int qualOfs, double totalMinErrorProbability) {
        if (qualOfs == 0 | qualOfs == probs.length) {
            return;
        }
        this.flowMatrix[1][flowIdx] = Math.min(probs[qualOfs - 1], probs[qualOfs]) <= totalMinErrorProbability ? Math.max(this.flowMatrix[1][flowIdx], this.perHmerMinErrorProbability) : Math.max(this.flowMatrix[1][flowIdx], Math.min(probs[qualOfs - 1], probs[qualOfs]));
    }

    private double estimateFillingValue() {
        byte[] quals = this.samRecord.getBaseQualities();
        double maxQual = 0.0;
        for (int i = 0; i < quals.length; ++i) {
            if (!((double)quals[i] > maxQual)) continue;
            maxQual = quals[i];
        }
        if (maxQual == 0.0) {
            maxQual = 40.0;
        }
        return Math.pow(10.0, -maxQual / 10.0);
    }

    public int getMaxHmer() {
        return this.maxHmer;
    }

    public int getNFlows() {
        return this.key.length;
    }

    private void validateSequence() {
        for (int b : this.key) {
            if (b <= this.maxHmer - 1) continue;
            this.validKey = false;
        }
        this.validKey = true;
    }

    public boolean isValid() {
        return this.validKey;
    }

    public double getProb(int flow, int hmer) {
        double prob = this.flowMatrix[hmer < this.maxHmer ? hmer : this.maxHmer][flow];
        return prob <= 1.0 ? prob : 1.0;
    }

    private static int findFirstNonZero(int[] array) {
        int result = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == 0) continue;
            result = i;
            break;
        }
        return result;
    }

    private static int findLastNonZero(int[] array) {
        int result = -1;
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] == 0) continue;
            result = i;
            break;
        }
        return result;
    }

    public int[] getKey() {
        return this.key;
    }

    private void applyFilteringFlowMatrix() {
        this.clipProbs();
    }

    private void clipProbs() {
        for (int i = 0; i < this.getMaxHmer(); ++i) {
            for (int j = 0; j < this.getNFlows(); ++j) {
                if (!(this.flowMatrix[i][j] <= this.perHmerMinErrorProbability) || this.key[j] == i) continue;
                this.flowMatrix[i][j] = this.perHmerMinErrorProbability;
            }
        }
    }

    public String getReadName() {
        return this.samRecord.getReadName();
    }
}

