/*
 * Decompiled with CFR 0.152.
 */
package picard.flow;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.util.SequenceUtil;

public class FlowReadGroupInfo {
    private static final String PLATFORM_ULTIMA = "ULTIMA";
    private static final String PLATFORM_LS454 = "LS454";
    public final String flowOrder;
    public final int maxClass;
    public final boolean isFlowPlatform;
    private String reversedFlowOrder = null;

    public FlowReadGroupInfo(SAMReadGroupRecord readGroup) {
        String mc;
        boolean bl = this.isFlowPlatform = PLATFORM_ULTIMA.equals(readGroup.getPlatform()) || PLATFORM_LS454.equals(readGroup.getPlatform());
        this.maxClass = this.isFlowPlatform ? ((mc = readGroup.getAttribute("mc")) == null ? 12 : Integer.parseInt(mc)) : 0;
        this.flowOrder = readGroup.getFlowOrder();
        if (PLATFORM_ULTIMA.equals(readGroup.getPlatform()) && this.flowOrder == null) {
            throw new RuntimeException("Malformed Ultima read group identified, aborting: " + String.valueOf(readGroup));
        }
    }

    public synchronized String getReversedFlowOrder() {
        if (this.reversedFlowOrder == null) {
            this.reversedFlowOrder = SequenceUtil.reverseComplement(this.flowOrder);
        }
        return this.reversedFlowOrder;
    }
}

