/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.samtools.util.StringUtil;
import org.broadinstitute.barclay.help.DocumentedFeature;

@DocumentedFeature(groupName="Metrics", summary="Metrics")
public class BarcodeMetric
extends MetricBase {
    public String BARCODE;
    public String BARCODE_WITHOUT_DELIMITER;
    public String BARCODE_NAME = "";
    public String LIBRARY_NAME = "";
    public long READS = 0L;
    public long PF_READS = 0L;
    public long PERFECT_MATCHES = 0L;
    public long PF_PERFECT_MATCHES = 0L;
    public long ONE_MISMATCH_MATCHES = 0L;
    public long PF_ONE_MISMATCH_MATCHES = 0L;
    public double PCT_MATCHES = 0.0;
    public double RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = 0.0;
    public double PF_PCT_MATCHES = 0.0;
    public double PF_RATIO_THIS_BARCODE_TO_BEST_BARCODE_PCT = 0.0;
    public double PF_NORMALIZED_MATCHES;
    protected byte[][] barcodeBytes;

    public BarcodeMetric(String barcodeName, String libraryName, String barcodeDisplay, String[] barcodeSeqs) {
        this.BARCODE = barcodeDisplay;
        this.BARCODE_WITHOUT_DELIMITER = barcodeDisplay.replaceAll("-", "");
        this.BARCODE_NAME = barcodeName;
        this.LIBRARY_NAME = libraryName;
        this.barcodeBytes = new byte[barcodeSeqs.length][];
        for (int i = 0; i < barcodeSeqs.length; ++i) {
            this.barcodeBytes[i] = StringUtil.stringToBytes(barcodeSeqs[i]);
        }
    }

    public BarcodeMetric() {
        this.barcodeBytes = null;
    }

    public BarcodeMetric copy() {
        BarcodeMetric result = new BarcodeMetric();
        result.BARCODE = this.BARCODE;
        result.BARCODE_WITHOUT_DELIMITER = this.BARCODE_WITHOUT_DELIMITER;
        result.BARCODE_NAME = this.BARCODE_NAME;
        result.LIBRARY_NAME = this.LIBRARY_NAME;
        result.barcodeBytes = this.barcodeBytes;
        return result;
    }

    public void merge(BarcodeMetric metric) {
        this.READS += metric.READS;
        this.PF_READS += metric.PF_READS;
        this.PERFECT_MATCHES += metric.PERFECT_MATCHES;
        this.PF_PERFECT_MATCHES += metric.PF_PERFECT_MATCHES;
        this.ONE_MISMATCH_MATCHES += metric.ONE_MISMATCH_MATCHES;
        this.PF_ONE_MISMATCH_MATCHES += metric.PF_ONE_MISMATCH_MATCHES;
    }
}

