/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import org.broadinstitute.barclay.argparser.CommandLineParser;
import picard.util.BarcodeEditDistanceQuery;
import picard.util.SingleBarcodeDistanceMetric;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DistanceMetric implements CommandLineParser.ClpEnum
{
    HAMMING("Hamming distance: The n-th base in the read is compared against the n-th base in the barcode. Unequal bases and low quality bases are considered mismatches. No-call read-bases are not considered mismatches. "){

        @Override
        protected int distance0(SingleBarcodeDistanceMetric editDistance) {
            return editDistance.hammingDistance();
        }
    }
    ,
    LENIENT_HAMMING("Leniant Hamming distance: The n-th base in the read is compared against the n-th base in the barcode. Unequal bases are considered mismatches. No-call read-bases, or those with low quality are not considered mismatches."){

        @Override
        protected int distance0(SingleBarcodeDistanceMetric editDistance) {
            return editDistance.lenientHammingDistance();
        }
    }
    ,
    FREE("FREE Metric: A Levenshtein-like metric that performs a simple Smith-Waterman with mismatch, gap open, and gap extend costs all equal to 1. Insertions or deletions at the ends of the read or barcode do not count toward the distance. No-call read-bases, or those with low quality are not considered mismatches."){

        @Override
        protected int distance0(SingleBarcodeDistanceMetric editDistance) {
            return editDistance.freeDistance();
        }
    };

    private final String helpString;

    private DistanceMetric(String helpString) {
        this.helpString = helpString;
    }

    protected abstract int distance0(SingleBarcodeDistanceMetric var1);

    public int distance(BarcodeEditDistanceQuery editDistance) {
        int numMismatches = 0;
        for (int j = 0; j < editDistance.barcodeBytes.length; ++j) {
            SingleBarcodeDistanceMetric singleBarcodeDistanceMetric;
            if ((numMismatches += this.distance0(singleBarcodeDistanceMetric = editDistance.getSingleBarcodeDistanceQuery(j, numMismatches))) <= editDistance.maximalInterestingDistance) continue;
            return numMismatches;
        }
        return numMismatches;
    }

    @Override
    public String getHelpDoc() {
        return this.helpString;
    }
}

