/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.BaseCallingProgramGroup;
import picard.illumina.CustomAdapterPair;
import picard.util.AdapterMarker;
import picard.util.AdapterPair;
import picard.util.IlluminaUtil;

@CommandLineProgramProperties(summary="Reads a SAM/BAM/CRAM file and rewrites it with new adapter-trimming tags.  <p>This tool clears any existing adapter-trimming tags (XT:i:) in the optional tag region of the input file.  The SAM/BAM/CRAM file must be sorted by query name.</p> <p>Outputs a metrics file histogram showing counts of bases_clipped per read.<h4>Usage example:</h4><pre>java -jar picard.jar MarkIlluminaAdapters \\<br /> INPUT=input.sam \\<br />METRICS=metrics.txt </pre><hr />", oneLineSummary="Reads a SAM/BAM/CRAM file and rewrites it with new adapter-trimming tags.  ", programGroup=BaseCallingProgramGroup.class)
@DocumentedFeature
public class MarkIlluminaAdapters
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Reads a SAM/BAM/CRAM file and rewrites it with new adapter-trimming tags.  ";
    static final String USAGE_DETAILS = "<p>This tool clears any existing adapter-trimming tags (XT:i:) in the optional tag region of the input file.  The SAM/BAM/CRAM file must be sorted by query name.</p> <p>Outputs a metrics file histogram showing counts of bases_clipped per read.<h4>Usage example:</h4><pre>java -jar picard.jar MarkIlluminaAdapters \\<br /> INPUT=input.sam \\<br />METRICS=metrics.txt </pre><hr />";
    @Argument(shortName="I")
    public File INPUT;
    @Argument(doc="If output is not specified, just the metrics are generated", shortName="O", optional=true)
    public File OUTPUT;
    @Argument(doc="Histogram showing counts of bases_clipped in how many reads", shortName="M")
    public File METRICS;
    @Argument(doc="The minimum number of bases to match over when clipping single-end reads.")
    public int MIN_MATCH_BASES_SE = 12;
    @Argument(doc="The minimum number of bases to match over (per-read) when clipping paired-end reads.")
    public int MIN_MATCH_BASES_PE = 6;
    @Argument(doc="The maximum mismatch error rate to tolerate when clipping single-end reads.")
    public double MAX_ERROR_RATE_SE = 0.1;
    @Argument(doc="The maximum mismatch error rate to tolerate when clipping paired-end reads.")
    public double MAX_ERROR_RATE_PE = 0.1;
    @Argument(doc="DEPRECATED. Whether this is a paired-end run. No longer used.", shortName="PE", optional=true)
    public Boolean PAIRED_RUN;
    @Argument(doc="Which adapters sequences to attempt to identify and clip.")
    public List<IlluminaUtil.IlluminaAdapterPair> ADAPTERS = CollectionUtil.makeList(IlluminaUtil.IlluminaAdapterPair.INDEXED, IlluminaUtil.IlluminaAdapterPair.DUAL_INDEXED, IlluminaUtil.IlluminaAdapterPair.PAIRED_END);
    @Argument(doc="For specifying adapters other than standard Illumina", optional=true)
    public String FIVE_PRIME_ADAPTER;
    @Argument(doc="For specifying adapters other than standard Illumina", optional=true)
    public String THREE_PRIME_ADAPTER;
    @Argument(doc="Adapters are truncated to this length to speed adapter matching.  Set to a large number to effectively disable truncation.")
    public int ADAPTER_TRUNCATION_LENGTH = 30;
    @Argument(doc="If looking for multiple adapter sequences, then after having seen this many adapters, shorten the list of sequences. Keep the adapters that were found most frequently in the input so far. Set to -1 if the input has a heterogeneous mix of adapters so shortening is undesirable.", shortName="APT")
    public int PRUNE_ADAPTER_LIST_AFTER_THIS_MANY_ADAPTERS_SEEN = 100;
    @Argument(doc="If pruning the adapter list, keep only this many adapter sequences when pruning the list (plus any adapters that were tied with the adapters being kept).")
    public int NUM_ADAPTERS_TO_KEEP = 1;
    private static final Log log = Log.getInstance(MarkIlluminaAdapters.class);

    @Override
    protected String[] customCommandLineValidation() {
        if (this.hasEitherAdapter()) {
            return new String[]{"THREE_PRIME_ADAPTER and FIVE_PRIME_ADAPTER must either both be null or both be set."};
        }
        return null;
    }

    private boolean hasEitherAdapter() {
        return this.FIVE_PRIME_ADAPTER != null && this.THREE_PRIME_ADAPTER == null || this.THREE_PRIME_ADAPTER != null && this.FIVE_PRIME_ADAPTER == null;
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.METRICS);
        SamReader in = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(this.INPUT);
        SAMFileHeader.SortOrder order = in.getFileHeader().getSortOrder();
        SAMFileWriter out = null;
        if (this.OUTPUT != null) {
            IOUtil.assertFileIsWritable(this.OUTPUT);
            out = new SAMFileWriterFactory().makeWriter(in.getFileHeader(), true, this.OUTPUT, this.REFERENCE_SEQUENCE);
        }
        Histogram<Integer> histo = new Histogram<Integer>("clipped_bases", "read_count");
        ArrayList<AdapterPair> tmp = new ArrayList<AdapterPair>();
        tmp.addAll(this.ADAPTERS);
        if (this.hasBothAdapters()) {
            tmp.add(new CustomAdapterPair(this.FIVE_PRIME_ADAPTER, this.THREE_PRIME_ADAPTER));
        }
        AdapterPair[] adapters = tmp.toArray(new AdapterPair[tmp.size()]);
        ProgressLogger progress = new ProgressLogger(log, 1000000, "Read");
        SAMRecordIterator iterator = in.iterator();
        AdapterMarker adapterMarker = new AdapterMarker(this.ADAPTER_TRUNCATION_LENGTH, adapters).setMaxPairErrorRate(this.MAX_ERROR_RATE_PE).setMinPairMatchBases(this.MIN_MATCH_BASES_PE).setMaxSingleEndErrorRate(this.MAX_ERROR_RATE_SE).setMinSingleEndMatchBases(this.MIN_MATCH_BASES_SE).setNumAdaptersToKeep(this.NUM_ADAPTERS_TO_KEEP).setThresholdForSelectingAdaptersToKeep(this.PRUNE_ADAPTER_LIST_AFTER_THIS_MANY_ADAPTERS_SEEN);
        while (iterator.hasNext()) {
            SAMRecord rec = (SAMRecord)iterator.next();
            SAMRecord rec2 = rec.getReadPairedFlag() && iterator.hasNext() ? (SAMRecord)iterator.next() : null;
            rec.setAttribute("XT", null);
            if (rec.getReadPairedFlag()) {
                SAMRecord second;
                SAMRecord first;
                if (order != SAMFileHeader.SortOrder.queryname) {
                    throw new PicardException("Input file must be sorted by queryname");
                }
                if (rec2 == null) {
                    throw new PicardException("Missing mate pair for paired read: " + rec.getReadName());
                }
                rec2.setAttribute("XT", null);
                if (!rec.getReadName().equals(rec2.getReadName())) {
                    throw new PicardException("Adjacent reads expected to be mate-pairs have different names: " + rec.getReadName() + ", " + rec2.getReadName());
                }
                if (rec.getFirstOfPairFlag() && rec2.getSecondOfPairFlag()) {
                    first = rec;
                    second = rec2;
                } else if (rec.getSecondOfPairFlag() && rec2.getFirstOfPairFlag()) {
                    first = rec2;
                    second = rec;
                } else {
                    throw new PicardException("Two reads with same name but not correctly marked as 1st/2nd of pair: " + rec.getReadName());
                }
                adapterMarker.adapterTrimIlluminaPairedReads(first, second);
            } else {
                adapterMarker.adapterTrimIlluminaSingleRead(rec);
            }
            for (SAMRecord r : new SAMRecord[]{rec, rec2}) {
                Integer clip;
                if (r == null) continue;
                progress.record(r);
                if (out != null) {
                    out.addAlignment(r);
                }
                if ((clip = r.getIntegerAttribute("XT")) == null) continue;
                histo.increment(r.getReadLength() - clip + 1);
            }
        }
        if (out != null) {
            out.close();
        }
        MetricsFile metricsFile = this.getMetricsFile();
        metricsFile.setHistogram(histo);
        metricsFile.write(this.METRICS);
        CloserUtil.close(in);
        return 0;
    }

    private boolean hasBothAdapters() {
        return this.FIVE_PRIME_ADAPTER != null && this.THREE_PRIME_ADAPTER != null;
    }
}

