/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.IlluminaFileMap;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.PerTileParser;
import picard.illumina.parser.PositionalData;
import picard.illumina.parser.readers.AbstractIlluminaPositionFileReader;

public class PosParser
extends PerTileParser<PositionalData> {
    private static Set<IlluminaDataType> supportedTypes = Collections.unmodifiableSet(CollectionUtil.makeSet(IlluminaDataType.Position));
    private final IlluminaFileUtil.SupportedIlluminaFormat fileType;

    public PosParser(IlluminaFileMap tilesToFiles, IlluminaFileUtil.SupportedIlluminaFormat fileType) {
        super(tilesToFiles);
        this.fileType = fileType;
    }

    public PosParser(IlluminaFileMap tilesToFiles, int startingTile, IlluminaFileUtil.SupportedIlluminaFormat fileType) {
        super(tilesToFiles, startingTile);
        this.fileType = fileType;
    }

    @Override
    protected CloseableIterator<PositionalData> makeTileIterator(File file) {
        return new CloseableIterator<PositionalData>(){
            private AbstractIlluminaPositionFileReader reader;
            final /* synthetic */ AbstractIlluminaPositionFileReader val$fileReader;
            {
                this.val$fileReader = abstractIlluminaPositionFileReader;
                this.reader = this.val$fileReader;
            }

            @Override
            public void close() {
                this.reader.close();
            }

            @Override
            public boolean hasNext() {
                return this.reader.hasNext();
            }

            @Override
            public PositionalData next() {
                final AbstractIlluminaPositionFileReader.PositionInfo nextValue = this.reader.next();
                return new PositionalData(){

                    @Override
                    public int getXCoordinate() {
                        return nextValue.xQseqCoord;
                    }

                    @Override
                    public int getYCoordinate() {
                        return nextValue.yQseqCoord;
                    }

                    public int getLane() {
                        return nextValue.lane;
                    }

                    public int getTile() {
                        return nextValue.tile;
                    }
                };
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return supportedTypes;
    }
}

