/*
 * Decompiled with CFR 0.152.
 */
package picard.nio;

import com.google.api.client.util.Strings;
import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.http.HttpTransportOptions;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.contrib.nio.CloudStorageConfiguration;
import com.google.cloud.storage.contrib.nio.CloudStorageFileSystemProvider;
import org.threeten.bp.Duration;

class GoogleStorageUtils {
    GoogleStorageUtils() {
    }

    public static void initialize() {
        CloudStorageFileSystemProvider.setDefaultCloudStorageConfiguration(GoogleStorageUtils.getCloudStorageConfiguration(20, null));
        CloudStorageFileSystemProvider.setStorageOptions(GoogleStorageUtils.setGenerousTimeouts(StorageOptions.newBuilder()).build());
    }

    private static CloudStorageConfiguration getCloudStorageConfiguration(int maxReopens, String requesterProject) {
        CloudStorageConfiguration.Builder builder = CloudStorageConfiguration.builder().maxChannelReopens(maxReopens);
        if (!Strings.isNullOrEmpty(requesterProject)) {
            builder = builder.autoDetectRequesterPays(true).userProject(requesterProject);
        }
        builder.usePseudoDirectories(true);
        return builder.build();
    }

    private static StorageOptions.Builder setGenerousTimeouts(StorageOptions.Builder builder) {
        return (StorageOptions.Builder)((StorageOptions.Builder)builder.setTransportOptions(HttpTransportOptions.newBuilder().setConnectTimeout(120000).setReadTimeout(120000).build())).setRetrySettings(RetrySettings.newBuilder().setMaxAttempts(15).setMaxRetryDelay(Duration.ofMillis(256000L)).setTotalTimeout(Duration.ofMillis(4000000L)).setInitialRetryDelay(Duration.ofMillis(1000L)).setRetryDelayMultiplier(2.0).setInitialRpcTimeout(Duration.ofMillis(180000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(180000L)).build());
    }
}

