/*
 * Decompiled with CFR 0.152.
 */
package picard.nio;

import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import picard.PicardException;
import picard.nio.DeleteRecursivelyOnExitPathHook;

public class PicardIOUtils {
    public static void deleteOnExit(Path fileToDelete) {
        DeleteRecursivelyOnExitPathHook.add(fileToDelete);
    }

    public static File createTempFile(String name, String extension) {
        return PicardIOUtils.createTempFileInDirectory(name, extension, null);
    }

    public static File createTempFileInDirectory(String name, String extension, File targetDir) {
        try {
            File file = File.createTempFile(name, extension, targetDir);
            file.deleteOnExit();
            new File(file.getAbsolutePath() + ".idx").deleteOnExit();
            new File(file.getAbsolutePath() + ".tbi").deleteOnExit();
            new File(file.getAbsolutePath() + ".bai").deleteOnExit();
            new File(file.getAbsolutePath().replaceAll(extension + "$", ".bai")).deleteOnExit();
            new File(file.getAbsolutePath() + ".md5").deleteOnExit();
            return file;
        }
        catch (IOException ex) {
            throw new PicardException("Cannot create temp file: " + ex.getMessage(), ex);
        }
    }

    public static void deleteRecursively(Path rootPath) {
        IOUtil.recursiveDelete(rootPath);
    }
}

