/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.PositionalArguments;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.sam.util.SAMComparisonArgumentCollection;
import picard.sam.util.SamComparison;

@CommandLineProgramProperties(summary="Compare two input SAM/BAM/CRAM files.  This tool initially compares the headers of the input files.  If the file headers are comparable, the tool can perform either strict comparisons for which each alignment and the header must be identical, or a more lenient check of \"equivalence\", where reads with mapping quality < LOW_MQ_THRESHOLD are allowed to have different alignments, duplicate marks are allowed to differ to account for ambiguities in selecting the representative read of a duplicate set, and some differences in headers is allowed.  By default, alignment comparisons, duplicate marking comparisons, and header comparisons are performed in the strict mode.  Results of comparison are summarised in  an output metrics file.<h3>Usage example:</h3><h4>CompareSAMs for exact matching:</h4><pre>java -jar picard.jar CompareSAMs \\<br />      file_1.bam \\<br />      file_2.bam \\<br />      O=comparison.tsv</pre>\n<h4>CompareSAMs for \"equivalence\":</h4>java -jar picard.jar CompareSAMs \\<br />      file_1.bam \\<br />      file_2.bam \\<br />      LENIENT_LOW_MQ_ALIGNMENT=true \\<br />      LENIENT_DUP=true \\<br />      O=comparison.tsv</pre>\n<h4>CompareSAMs for \"equivalence\", allow certain differences in header:</h4>java -jar picard.jar CompareSAMs \\<br />      file_1.bam \\<br />      file_2.bam \\<br />      LENIENT_LOW_MQ_ALIGNMENT=true \\<br />      LENIENT_DUP=true \\<br />      LENIENT_HEADER=true \\<br />      O=comparison.tsv<hr />", oneLineSummary="Compare two input SAM/BAM/CRAM files.  ", programGroup=DiagnosticsAndQCProgramGroup.class)
@DocumentedFeature
public class CompareSAMs
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Compare two input SAM/BAM/CRAM files.  ";
    static final String USAGE_DETAILS = "This tool initially compares the headers of the input files.  If the file headers are comparable, the tool can perform either strict comparisons for which each alignment and the header must be identical, or a more lenient check of \"equivalence\", where reads with mapping quality < LOW_MQ_THRESHOLD are allowed to have different alignments, duplicate marks are allowed to differ to account for ambiguities in selecting the representative read of a duplicate set, and some differences in headers is allowed.  By default, alignment comparisons, duplicate marking comparisons, and header comparisons are performed in the strict mode.  Results of comparison are summarised in  an output metrics file.<h3>Usage example:</h3><h4>CompareSAMs for exact matching:</h4><pre>java -jar picard.jar CompareSAMs \\<br />      file_1.bam \\<br />      file_2.bam \\<br />      O=comparison.tsv</pre>\n<h4>CompareSAMs for \"equivalence\":</h4>java -jar picard.jar CompareSAMs \\<br />      file_1.bam \\<br />      file_2.bam \\<br />      LENIENT_LOW_MQ_ALIGNMENT=true \\<br />      LENIENT_DUP=true \\<br />      O=comparison.tsv</pre>\n<h4>CompareSAMs for \"equivalence\", allow certain differences in header:</h4>java -jar picard.jar CompareSAMs \\<br />      file_1.bam \\<br />      file_2.bam \\<br />      LENIENT_LOW_MQ_ALIGNMENT=true \\<br />      LENIENT_DUP=true \\<br />      LENIENT_HEADER=true \\<br />      O=comparison.tsv<hr />";
    @PositionalArguments(doc="Exactly two input SAM/BAM/CRAM files to compare to one another.", minElements=2, maxElements=2)
    public List<File> SAM_FILES;
    @Argument(shortName="O", doc="Output file to write comparison results to.", optional=true)
    public File OUTPUT;
    @ArgumentCollection
    public SAMComparisonArgumentCollection samComparisonArgumentCollection = new SAMComparisonArgumentCollection();

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int doWork() {
        SamReaderFactory samReaderFactory = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE);
        try (SamReader samReader1 = samReaderFactory.open(this.SAM_FILES.get(0));){
            int n;
            block17: {
                SamReader samReader2 = samReaderFactory.open(this.SAM_FILES.get(1));
                try {
                    SamComparison comparison = new SamComparison(samReader1, samReader2, this.SAM_FILES.get(0).getAbsolutePath(), this.SAM_FILES.get(1).getAbsolutePath(), this.samComparisonArgumentCollection);
                    if (this.OUTPUT != null) {
                        comparison.writeReport(this.OUTPUT, this.getDefaultHeaders());
                    }
                    if (comparison.areEqual()) {
                        System.out.println("SAM files match.");
                    } else {
                        System.out.println("SAM files differ.");
                    }
                    int n2 = n = comparison.areEqual() ? 0 : 1;
                    if (samReader2 == null) break block17;
                }
                catch (Throwable throwable) {
                    if (samReader2 != null) {
                        try {
                            samReader2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                samReader2.close();
            }
            return n;
        }
        catch (IOException e) {
            throw new RuntimeIOException("Error opening file", e);
        }
    }
}

