/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.SAMRecord;
import picard.analysis.MergeableMetricBase;
import picard.sam.DuplicationMetrics;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicates;
import picard.util.MathUtil;

public class FlowBasedDuplicationMetrics
extends DuplicationMetrics {
    @MergeableMetricBase.MergeByAdding
    public long UNPAIRED_WITH_TLEN;
    @MergeableMetricBase.MergeByAdding
    public long UNPAIRED_DUPS_WITHOUT_TLEN;
    @MergeableMetricBase.MergeByAdding
    public long UNPAIRED_DUPS_WITH_TLEN;
    @MergeableMetricBase.NoMergingIsDerived
    public Double UNPAIRED_DUP_RATE_WITHOUT_TLEN;
    @MergeableMetricBase.NoMergingIsDerived
    public Double UNPAIRED_DUP_RATE_WITH_TLEN;

    @Override
    public void calculateDerivedFields() {
        super.calculateDerivedFields();
        this.UNPAIRED_DUP_RATE_WITHOUT_TLEN = MathUtil.divide(this.UNPAIRED_DUPS_WITHOUT_TLEN, this.UNPAIRED_READS_EXAMINED - this.UNPAIRED_WITH_TLEN);
        this.UNPAIRED_DUP_RATE_WITH_TLEN = MathUtil.divide(this.UNPAIRED_DUPS_WITH_TLEN, this.UNPAIRED_WITH_TLEN);
    }

    @Override
    public void addDuplicateReadToMetrics(SAMRecord rec) {
        super.addDuplicateReadToMetrics(rec);
        if (!(rec.isSecondaryOrSupplementary() || rec.getReadUnmappedFlag() || rec.getReadPairedFlag() && !rec.getMateUnmappedFlag())) {
            if (ReadEndsForMarkDuplicates.isSingleEndReadKnownFragment(rec)) {
                ++this.UNPAIRED_DUPS_WITH_TLEN;
            } else {
                ++this.UNPAIRED_DUPS_WITHOUT_TLEN;
            }
        }
    }

    @Override
    public void addReadToLibraryMetrics(SAMRecord rec) {
        super.addReadToLibraryMetrics(rec);
        if (ReadEndsForMarkDuplicates.isSingleEndReadKnownFragment(rec)) {
            ++this.UNPAIRED_WITH_TLEN;
        }
    }
}

