/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.metrics.MetricBase;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.sam.util.SamComparison;

@DocumentedFeature(groupName="Metrics", summary="Metrics")
public class SamComparisonMetric
extends MetricBase {
    public String LEFT_FILE;
    public String RIGHT_FILE;
    public long MAPPINGS_MATCH;
    public long MAPPINGS_DIFFER;
    public long UNMAPPED_BOTH;
    public long UNMAPPED_LEFT;
    public long UNMAPPED_RIGHT;
    public long MISSING_LEFT;
    public long MISSING_RIGHT;
    public long DUPLICATE_MARKINGS_DIFFER;
    public boolean ARE_EQUAL;

    public boolean allVisitedAlignmentsEqual() {
        return this.MISSING_LEFT <= 0L && this.MISSING_RIGHT <= 0L && this.MAPPINGS_DIFFER <= 0L && this.UNMAPPED_LEFT <= 0L && this.UNMAPPED_RIGHT <= 0L;
    }

    public void updateMetric(SamComparison.AlignmentComparison comp) {
        switch (comp) {
            case UNMAPPED_BOTH: {
                ++this.UNMAPPED_BOTH;
                break;
            }
            case UNMAPPED_LEFT: {
                ++this.UNMAPPED_LEFT;
                break;
            }
            case UNMAPPED_RIGHT: {
                ++this.UNMAPPED_RIGHT;
                break;
            }
            case MAPPINGS_DIFFER: {
                ++this.MAPPINGS_DIFFER;
                break;
            }
            case MAPPINGS_MATCH: {
                ++this.MAPPINGS_MATCH;
                break;
            }
            default: {
                throw new PicardException("Unhandled comparison type: " + String.valueOf((Object)comp));
            }
        }
    }
}

