/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates;

import com.google.common.annotations.VisibleForTesting;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Log;
import java.util.ArrayList;
import picard.sam.markduplicates.MarkDuplicates;
import picard.sam.markduplicates.MarkDuplicatesForFlowArgumentCollection;
import picard.sam.markduplicates.MarkDuplicatesHelper;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicates;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicatesWithBarcodes;

public class MarkDuplicatesForFlowHelper
implements MarkDuplicatesHelper {
    private final Log log = Log.getInstance(MarkDuplicatesForFlowHelper.class);
    private static final int END_INSIGNIFICANT_VALUE = 0;
    private static final String ATTR_DUPLICATE_SCORE = "ForFlowDuplicateScore";
    public static final String CLIPPING_TAG_NAME = "tm";
    public static final char[] CLIPPING_TAG_CONTAINS_A = new char[]{'A'};
    public static final char[] CLIPPING_TAG_CONTAINS_AQ = new char[]{'A', 'Q'};
    public static final char[] CLIPPING_TAG_CONTAINS_QZ = new char[]{'Q', 'Z'};
    public static final int DIST_FROM_END = 10;
    private final MarkDuplicates md;

    public MarkDuplicatesForFlowHelper(MarkDuplicates md) {
        this.md = md;
        this.validateFlowParameteres();
    }

    private void validateFlowParameteres() {
        if (this.md.flowBasedArguments.FLOW_UNPAIRED_END_UNCERTAINTY != 0 && !this.md.flowBasedArguments.FLOW_USE_END_IN_UNPAIRED_READS) {
            throw new IllegalArgumentException("Invalid parameter combination. UNPAIRED_END_UNCERTAINTY can not be specified when USE_END_IN_UNPAIRED_READS not specified");
        }
    }

    @Override
    public void generateDuplicateIndexes(boolean useBarcodes, boolean indexOpticalDuplicates) {
        this.md.sortIndicesForDuplicates(indexOpticalDuplicates);
        if (this.md.pairSort.iterator().hasNext()) {
            throw new IllegalArgumentException("Flow based code does not support paired reads");
        }
        this.md.pairSort.cleanup();
        this.md.pairSort = null;
        this.log.info("Traversing fragment information and detecting duplicates.");
        ReadEndsForMarkDuplicates firstOfNextChunk = null;
        int nextChunkRead1Coordinate2Min = Integer.MAX_VALUE;
        int nextChunkRead1Coordinate2Max = Integer.MIN_VALUE;
        int nextChunkRead1Coordinate1Min = Integer.MAX_VALUE;
        int nextChunkRead1Coordinate1Max = Integer.MIN_VALUE;
        ArrayList<ReadEndsForMarkDuplicates> nextChunk = new ArrayList<ReadEndsForMarkDuplicates>(200);
        boolean containsPairs = false;
        boolean containsFrags = false;
        for (ReadEndsForMarkDuplicates next : this.md.fragSort) {
            if (firstOfNextChunk != null && this.areComparableForDuplicatesWithEndSignificance(firstOfNextChunk, next, useBarcodes, nextChunkRead1Coordinate2Min, nextChunkRead1Coordinate2Max, nextChunkRead1Coordinate1Min, nextChunkRead1Coordinate1Max)) {
                nextChunk.add(next);
                containsPairs = containsPairs || next.isPaired();
                boolean bl = containsFrags = containsFrags || !next.isPaired();
                if (next.read2Coordinate == 0) continue;
                nextChunkRead1Coordinate2Min = Math.min(nextChunkRead1Coordinate2Min, next.read2Coordinate);
                nextChunkRead1Coordinate2Max = Math.max(nextChunkRead1Coordinate2Max, next.read2Coordinate);
                nextChunkRead1Coordinate1Min = Math.min(nextChunkRead1Coordinate1Min, next.read1Coordinate);
                nextChunkRead1Coordinate1Max = Math.max(nextChunkRead1Coordinate1Max, next.read1Coordinate);
                if (firstOfNextChunk.read2Coordinate != 0) continue;
                firstOfNextChunk = next;
                continue;
            }
            if (nextChunk.size() > 1 && containsFrags) {
                this.md.markDuplicateFragments(nextChunk, containsPairs);
            }
            nextChunk.clear();
            nextChunk.add(next);
            firstOfNextChunk = next;
            nextChunkRead1Coordinate1Min = nextChunkRead1Coordinate1Max = next.read1Coordinate;
            if (next.read2Coordinate != 0) {
                nextChunkRead1Coordinate2Min = nextChunkRead1Coordinate2Max = next.read2Coordinate;
            } else {
                nextChunkRead1Coordinate2Min = Integer.MAX_VALUE;
                nextChunkRead1Coordinate2Max = Integer.MIN_VALUE;
            }
            containsPairs = next.isPaired();
            containsFrags = !next.isPaired();
        }
        this.md.markDuplicateFragments(nextChunk, containsPairs);
        this.md.fragSort.cleanup();
        this.md.fragSort = null;
        this.log.info("Sorting list of duplicate records.");
        this.md.duplicateIndexes.doneAddingStartIteration();
        if (this.md.opticalDuplicateIndexes != null) {
            this.md.opticalDuplicateIndexes.doneAddingStartIteration();
        }
        if (this.md.TAG_DUPLICATE_SET_MEMBERS) {
            this.md.representativeReadIndicesForDuplicates.doneAdding();
        }
    }

    @Override
    public ReadEndsForMarkDuplicates buildReadEnds(SAMFileHeader header, long index, SAMRecord rec, boolean useBarcodes) {
        ReadEndsForMarkDuplicates ends = this.md.buildReadEnds(header, index, rec, useBarcodes);
        if (rec.getReadPairedFlag() && !rec.getMateUnmappedFlag()) {
            throw new IllegalArgumentException("FLOW_MODE does not support paired reads. offending read: " + String.valueOf(rec));
        }
        ends.read1Coordinate = MarkDuplicatesForFlowHelper.getReadEndCoordinate(rec, !rec.getReadNegativeStrandFlag(), true, this.md.flowBasedArguments);
        if (this.md.flowBasedArguments.FLOW_USE_END_IN_UNPAIRED_READS) {
            ends.read2Coordinate = MarkDuplicatesForFlowHelper.getReadEndCoordinate(rec, rec.getReadNegativeStrandFlag(), false, this.md.flowBasedArguments);
        }
        ends.score = this.computeFlowDuplicateScore(rec, ends.read2Coordinate);
        return ends;
    }

    @Override
    public short getReadDuplicateScore(SAMRecord rec, ReadEndsForMarkDuplicates pairedEnds) {
        if (this.md.flowBasedArguments.FLOW_MODE) {
            return this.computeFlowDuplicateScore(rec, pairedEnds.read2Coordinate);
        }
        return this.md.getReadDuplicateScore(rec, pairedEnds);
    }

    protected boolean areComparableForDuplicates(ReadEndsForMarkDuplicates lhs, ReadEndsForMarkDuplicates rhs, boolean compareRead2, boolean useBarcodes) {
        boolean areComparable;
        boolean bl = areComparable = lhs.libraryId == rhs.libraryId;
        if (useBarcodes && areComparable) {
            ReadEndsForMarkDuplicatesWithBarcodes lhsWithBarcodes = (ReadEndsForMarkDuplicatesWithBarcodes)lhs;
            ReadEndsForMarkDuplicatesWithBarcodes rhsWithBarcodes = (ReadEndsForMarkDuplicatesWithBarcodes)rhs;
            boolean bl2 = areComparable = lhsWithBarcodes.barcode == rhsWithBarcodes.barcode && lhsWithBarcodes.readOneBarcode == rhsWithBarcodes.readOneBarcode && lhsWithBarcodes.readTwoBarcode == rhsWithBarcodes.readTwoBarcode;
        }
        if (areComparable) {
            boolean bl3 = areComparable = lhs.read1ReferenceIndex == rhs.read1ReferenceIndex && lhs.orientation == rhs.orientation;
        }
        if (areComparable && compareRead2) {
            areComparable = lhs.read2ReferenceIndex == rhs.read2ReferenceIndex && lhs.read2Coordinate == rhs.read2Coordinate;
        }
        return areComparable;
    }

    private boolean areComparableForDuplicatesWithEndSignificance(ReadEndsForMarkDuplicates lhs, ReadEndsForMarkDuplicates rhs, boolean useBarcodes, int lhsRead1Coordinate2Min, int lhsRead1Coordinate2Max, int lhsRead1Coordinate1Min, int lhsRead1Coordinate1Max) {
        boolean areComparable = this.areComparableForDuplicates(lhs, rhs, false, useBarcodes);
        if (areComparable) {
            areComparable = this.endCoorInRangeWithUncertainty(lhsRead1Coordinate1Min, lhsRead1Coordinate1Max, rhs.read1Coordinate, this.md.flowBasedArguments.FLOW_UNPAIRED_START_UNCERTAINTY);
        }
        if (areComparable) {
            areComparable = !this.endCoorSignificant(lhs.read2Coordinate, rhs.read2Coordinate) || this.endCoorInRangeWithUncertainty(lhsRead1Coordinate2Min, lhsRead1Coordinate2Max, rhs.read2Coordinate, this.md.flowBasedArguments.FLOW_UNPAIRED_END_UNCERTAINTY);
        }
        return areComparable;
    }

    private boolean endCoorSignificant(int lhsCoor, int rhsCoor) {
        return lhsCoor != 0 && rhsCoor != 0;
    }

    private boolean endCoorInRangeWithUncertainty(int lhsCoorMin, int lhsCoorMax, int rhsCoor, int uncertainty) {
        return rhsCoor >= lhsCoorMin - uncertainty && rhsCoor <= lhsCoorMax + uncertainty;
    }

    protected static int getFlowSumOfBaseQualities(SAMRecord rec, int threshold) {
        int score = 0;
        byte[] quals = rec.getBaseQualities();
        byte[] bases = rec.getReadBases();
        int startingOffset = !rec.getReadNegativeStrandFlag() ? 0 : bases.length - 1;
        int endOffset = !rec.getReadNegativeStrandFlag() ? bases.length : -1;
        int iterIncr = !rec.getReadNegativeStrandFlag() ? 1 : -1;
        byte lastBase = 0;
        int effectiveQual = 0;
        for (int i = startingOffset; i != endOffset; i += iterIncr) {
            byte base = bases[i];
            if (base != lastBase) {
                effectiveQual = quals[i];
            }
            if (effectiveQual >= threshold) {
                score += effectiveQual;
            }
            lastBase = base;
        }
        return score;
    }

    protected static int getFlowSumOfBaseQualitiesNearEnds(SAMRecord rec, int dist) {
        byte base;
        int i;
        byte score = 100;
        byte[] quals = rec.getBaseQualities();
        byte[] bases = rec.getReadBases();
        boolean insideHpol = false;
        if (dist > bases.length) {
            dist = bases.length;
        }
        for (i = 0; i < dist || insideHpol; ++i) {
            base = bases[i];
            insideHpol = i != bases.length - 1 && base == bases[i + 1];
            if (quals[i] >= score) continue;
            score = quals[i];
        }
        for (i = bases.length - 1; i > bases.length - 1 - dist || insideHpol; --i) {
            base = bases[i];
            insideHpol = i != 0 && base == bases[i - 1];
            if (quals[i] >= score) continue;
            score = quals[i];
        }
        return score;
    }

    private short computeFlowDuplicateScore(SAMRecord rec, int end) {
        if (end == 0) {
            return -1;
        }
        Short storedScore = (Short)rec.getTransientAttribute(ATTR_DUPLICATE_SCORE);
        if (storedScore == null) {
            short score = 0;
            if (this.md.flowBasedArguments.FLOW_DUP_STRATEGY == MarkDuplicatesForFlowArgumentCollection.FLOW_DUPLICATE_SELECTION_STRATEGY.FLOW_QUALITY_SUM_STRATEGY) {
                score = (short)(score + (short)Math.min(MarkDuplicatesForFlowHelper.getFlowSumOfBaseQualities(rec, this.md.flowBasedArguments.FLOW_EFFECTIVE_QUALITY_THRESHOLD), 16383));
            } else if (this.md.flowBasedArguments.FLOW_DUP_STRATEGY == MarkDuplicatesForFlowArgumentCollection.FLOW_DUPLICATE_SELECTION_STRATEGY.FLOW_END_QUALITY_STRATEGY) {
                score = (short)(score + (short)Math.min(MarkDuplicatesForFlowHelper.getFlowSumOfBaseQualitiesNearEnds(rec, 10), 16383));
            } else {
                throw new IllegalArgumentException("Unknown flow duplicate selection strategy: " + String.valueOf((Object)this.md.flowBasedArguments.FLOW_DUP_STRATEGY));
            }
            score = (short)(score + (rec.getReadFailsVendorQualityCheckFlag() ? -16384 : 0));
            storedScore = score;
            rec.setTransientAttribute(ATTR_DUPLICATE_SCORE, storedScore);
        }
        return storedScore;
    }

    @VisibleForTesting
    protected static int getReadEndCoordinate(SAMRecord rec, boolean startEnd, boolean certain, MarkDuplicatesForFlowArgumentCollection flowBasedArguments) {
        int alignmentCoor;
        FlowOrder flowOrder = new FlowOrder(rec);
        int unclippedCoor = startEnd ? rec.getUnclippedStart() : rec.getUnclippedEnd();
        int n = alignmentCoor = startEnd ? rec.getAlignmentStart() : rec.getAlignmentEnd();
        if (flowOrder.isValid()) {
            if (flowBasedArguments.FLOW_USE_UNPAIRED_CLIPPED_END) {
                return alignmentCoor;
            }
            if (certain && flowBasedArguments.FLOW_SKIP_FIRST_N_FLOWS != 0) {
                int hmerSize;
                byte[] bases = rec.getReadBases();
                byte hmerBase = startEnd ? bases[0] : bases[bases.length - 1];
                int hmersLeft = flowBasedArguments.FLOW_SKIP_FIRST_N_FLOWS;
                while (flowOrder.current() != hmerBase) {
                    flowOrder.advance();
                    --hmersLeft;
                }
                for (hmerSize = 1; hmerSize < bases.length; ++hmerSize) {
                    if ((startEnd ? bases[hmerSize] : bases[bases.length - 1 - hmerSize]) == hmerBase) continue;
                    if (--hmersLeft <= 0) break;
                    hmerBase = startEnd ? bases[hmerSize] : bases[bases.length - 1 - hmerSize];
                    flowOrder.advance();
                    while (flowOrder.current() != hmerBase) {
                        flowOrder.advance();
                        --hmersLeft;
                    }
                    if (hmersLeft <= 0) break;
                }
                int coor = unclippedCoor + (startEnd ? hmerSize : -hmerSize);
                return flowBasedArguments.FLOW_USE_UNPAIRED_CLIPPED_END ? (startEnd ? Math.max(coor, alignmentCoor) : Math.min(coor, alignmentCoor)) : coor;
            }
            if (flowBasedArguments.FLOW_Q_IS_KNOWN_END ? MarkDuplicatesForFlowHelper.isAdapterClipped(rec) : MarkDuplicatesForFlowHelper.isAdapterClippedWithQ(rec)) {
                return unclippedCoor;
            }
            if (!certain && MarkDuplicatesForFlowHelper.isQualityClipped(rec)) {
                return 0;
            }
        }
        return unclippedCoor;
    }

    public static boolean isAdapterClipped(SAMRecord rec) {
        return MarkDuplicatesForFlowHelper.clippingTagContainsAny(rec, CLIPPING_TAG_CONTAINS_A);
    }

    public static boolean isAdapterClippedWithQ(SAMRecord rec) {
        return MarkDuplicatesForFlowHelper.clippingTagContainsAny(rec, CLIPPING_TAG_CONTAINS_AQ);
    }

    public static boolean isQualityClipped(SAMRecord rec) {
        return MarkDuplicatesForFlowHelper.clippingTagContainsAny(rec, CLIPPING_TAG_CONTAINS_QZ);
    }

    private static boolean clippingTagContainsAny(SAMRecord rec, char[] chars) {
        String clippingTagValue = rec.getStringAttribute(CLIPPING_TAG_NAME);
        if (clippingTagValue == null) {
            return false;
        }
        for (char ch : chars) {
            if (clippingTagValue.indexOf(ch) < 0) continue;
            return true;
        }
        return false;
    }

    private static class FlowOrder {
        byte[] flowOrder;
        int flowIndex = 0;

        private FlowOrder(SAMRecord rec) {
            if (rec.getReadGroup() != null && rec.getReadGroup().getFlowOrder() != null) {
                this.flowOrder = rec.getReadGroup().getFlowOrder().getBytes();
                return;
            }
            SAMFileHeader header = rec.getHeader();
            for (SAMReadGroupRecord rg : header.getReadGroups()) {
                if (rg.getFlowOrder() == null) continue;
                this.flowOrder = rg.getFlowOrder().getBytes();
                return;
            }
            this.flowOrder = null;
        }

        private boolean isValid() {
            return this.flowOrder != null;
        }

        private void advance() {
            if (++this.flowIndex >= this.flowOrder.length) {
                this.flowIndex = 0;
            }
        }

        private byte current() {
            return this.flowOrder[this.flowIndex];
        }
    }
}

