/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.util.SortingCollection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import picard.PicardException;
import picard.sam.util.RepresentativeReadIndexer;

public class RepresentativeReadIndexerCodec
implements SortingCollection.Codec<RepresentativeReadIndexer> {
    protected DataInputStream in;
    protected DataOutputStream out;

    @Override
    public SortingCollection.Codec<RepresentativeReadIndexer> clone() {
        return new RepresentativeReadIndexerCodec();
    }

    @Override
    public void setOutputStream(OutputStream os) {
        this.out = new DataOutputStream(os);
    }

    @Override
    public void setInputStream(InputStream is) {
        this.in = new DataInputStream(is);
    }

    public DataInputStream getInputStream() {
        return this.in;
    }

    public DataOutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void encode(RepresentativeReadIndexer rni) {
        try {
            this.out.writeInt(rni.readIndexInFile);
            this.out.writeInt(rni.setSize);
            this.out.writeInt(rni.representativeReadIndexInFile);
        }
        catch (IOException ioe) {
            throw new PicardException("Exception writing ReadEnds to file.", ioe);
        }
    }

    @Override
    public RepresentativeReadIndexer decode() {
        RepresentativeReadIndexer rni = new RepresentativeReadIndexer();
        try {
            try {
                rni.readIndexInFile = this.in.readInt();
            }
            catch (EOFException eof) {
                return null;
            }
            rni.setSize = this.in.readInt();
            rni.representativeReadIndexInFile = this.in.readInt();
            return rni;
        }
        catch (IOException ioe) {
            throw new PicardException("Exception writing ReadEnds to file.", ioe);
        }
    }
}

