/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import htsjdk.samtools.util.Tuple;
import picard.PicardException;
import picard.util.AdapterPair;

public class ClippingUtility {
    public static final int MIN_MATCH_BASES = 12;
    public static final int MIN_MATCH_PE_BASES = 6;
    public static final double MAX_ERROR_RATE = 0.1;
    public static final double MAX_PE_ERROR_RATE = 0.1;
    public static final int NO_MATCH = -1;
    private static final Log log = Log.getInstance(ClippingUtility.class);

    @Deprecated
    public static void adapterTrimIlluminaSingleRead(SAMRecord read, AdapterPair adapter) {
        ClippingUtility.adapterTrimIlluminaSingleRead(read, 12, 0.1, adapter);
    }

    @Deprecated
    public static void adapterTrimIlluminaSingleRead(SAMRecord read, AdapterPair adapter, int minMatchBases, double maxErrorRate) {
        ClippingUtility.adapterTrimIlluminaSingleRead(read, minMatchBases, maxErrorRate, adapter);
    }

    public static AdapterPair adapterTrimIlluminaSingleRead(SAMRecord read, AdapterPair ... adapters) {
        return ClippingUtility.adapterTrimIlluminaSingleRead(read, 12, 0.1, adapters);
    }

    public static AdapterPair adapterTrimIlluminaSingleRead(SAMRecord read, int minMatchBases, double maxErrorRate, AdapterPair ... adapters) {
        for (AdapterPair adapter : adapters) {
            int indexOfAdapterSequence = ClippingUtility.findIndexOfClipSequence(ClippingUtility.getReadBases(read), adapter.get3PrimeAdapterBytes(), minMatchBases, maxErrorRate);
            if (indexOfAdapterSequence == -1) continue;
            read.setAttribute("XT", (Object)(indexOfAdapterSequence + 1));
            return adapter;
        }
        return null;
    }

    public static Tuple<AdapterPair, Integer> findAdapterPairAndIndexForSingleRead(byte[] read, int minMatchBases, double maxErrorRate, int templateIndex, AdapterPair ... adapters) {
        for (AdapterPair adapter : adapters) {
            int indexOfAdapterSequence;
            if (templateIndex == 1) {
                indexOfAdapterSequence = ClippingUtility.findIndexOfClipSequence(read, adapter.get3PrimeAdapterBytes(), minMatchBases, maxErrorRate);
            } else if (templateIndex == 2) {
                indexOfAdapterSequence = ClippingUtility.findIndexOfClipSequence(read, adapter.get5PrimeAdapterBytesInReadOrder(), minMatchBases, maxErrorRate);
            } else {
                throw new PicardException("Read template index must be 1 or 2");
            }
            if (indexOfAdapterSequence == -1) continue;
            return new Tuple<AdapterPair, Integer>(adapter, indexOfAdapterSequence);
        }
        return null;
    }

    @Deprecated
    public static String adapterTrimIlluminaPairedReads(SAMRecord read1, SAMRecord read2, AdapterPair adapters) {
        ClippingUtility.adapterTrimIlluminaPairedReads(read1, read2, 6, 0.1, adapters);
        return null;
    }

    @Deprecated
    public static String adapterTrimIlluminaPairedReads(SAMRecord read1, SAMRecord read2, AdapterPair adapters, int minMatchBases, double maxErrorRate) {
        ClippingUtility.adapterTrimIlluminaPairedReads(read1, read2, minMatchBases, maxErrorRate, adapters);
        return null;
    }

    public static AdapterPair adapterTrimIlluminaPairedReads(SAMRecord read1, SAMRecord read2, AdapterPair ... adapters) {
        return ClippingUtility.adapterTrimIlluminaPairedReads(read1, read2, 6, 0.1, adapters);
    }

    public static AdapterPair adapterTrimIlluminaPairedReads(SAMRecord read1, SAMRecord read2, int minMatchBases, double maxErrorRate, AdapterPair ... adapters) {
        AdapterPair matched = null;
        for (AdapterPair adapterPair : adapters) {
            int index2;
            int index1 = ClippingUtility.findIndexOfClipSequence(ClippingUtility.getReadBases(read1), adapterPair.get3PrimeAdapterBytes(), minMatchBases, maxErrorRate);
            if (index1 == (index2 = ClippingUtility.findIndexOfClipSequence(ClippingUtility.getReadBases(read2), adapterPair.get5PrimeAdapterBytesInReadOrder(), minMatchBases, maxErrorRate))) {
                if (index1 == -1) continue;
                read1.setAttribute("XT", (Object)(index1 + 1));
                read2.setAttribute("XT", (Object)(index2 + 1));
                return adapterPair;
            }
            if (index1 != -1 && index2 != -1 || !ClippingUtility.attemptOneSidedMatch(read1, read2, index1, index2, 2 * minMatchBases)) continue;
            matched = adapterPair;
        }
        return matched;
    }

    private static boolean attemptOneSidedMatch(SAMRecord read1, SAMRecord read2, int index1, int index2, int stricterMinMatchBases) {
        SAMRecord matchedRead;
        int matchedIndex = index1 == -1 ? index2 : index1;
        SAMRecord sAMRecord = matchedRead = index1 == -1 ? read2 : read1;
        if (matchedRead.getReadLength() - matchedIndex >= stricterMinMatchBases) {
            if (read1.getReadBases().length > matchedIndex) {
                read1.setAttribute("XT", (Object)(matchedIndex + 1));
            }
            if (read2.getReadBases().length > matchedIndex) {
                read2.setAttribute("XT", (Object)(matchedIndex + 1));
            }
            return true;
        }
        return false;
    }

    private static byte[] getReadBases(SAMRecord read) {
        if (!read.getReadNegativeStrandFlag()) {
            return read.getReadBases();
        }
        byte[] reverseComplementedBases = new byte[read.getReadBases().length];
        System.arraycopy(read.getReadBases(), 0, reverseComplementedBases, 0, reverseComplementedBases.length);
        SequenceUtil.reverseComplement(reverseComplementedBases);
        return reverseComplementedBases;
    }

    public static int findIndexOfClipSequence(byte[] read, byte[] adapterSequence, int minMatch, double maxErrorRate) {
        if (read == null || read.length < minMatch) {
            return -1;
        }
        boolean minClipPosition = false;
        block0: for (int start = read.length - minMatch; start > -1; --start) {
            int length = Math.min(read.length - start, adapterSequence.length);
            int mismatchesAllowed = (int)((double)length * maxErrorRate);
            int mismatches = 0;
            for (int i = 0; i < length; ++i) {
                if (!SequenceUtil.isNoCall(adapterSequence[i]) && !SequenceUtil.basesEqual(adapterSequence[i], read[start + i]) && ++mismatches > mismatchesAllowed) continue block0;
            }
            return start;
        }
        return -1;
    }
}

