/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.variant.variantcontext.VariantContext;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.vcf.GenotypeConcordanceCounts;
import picard.vcf.GenotypeConcordanceScheme;
import picard.vcf.GenotypeConcordanceSchemeFactory;

@DocumentedFeature(groupName="Metrics", summary="Metrics")
public class GenotypeConcordanceSummaryMetrics
extends MetricBase {
    public VariantContext.Type VARIANT_TYPE;
    public String TRUTH_SAMPLE;
    public String CALL_SAMPLE;
    public double HET_SENSITIVITY;
    public double HET_PPV;
    public double HET_SPECIFICITY;
    public double HOMVAR_SENSITIVITY;
    public double HOMVAR_PPV;
    public double HOMVAR_SPECIFICITY;
    public double VAR_SENSITIVITY;
    public double VAR_PPV;
    public double VAR_SPECIFICITY;
    public double GENOTYPE_CONCORDANCE;
    public double NON_REF_GENOTYPE_CONCORDANCE;

    public GenotypeConcordanceSummaryMetrics() {
    }

    public GenotypeConcordanceSummaryMetrics(VariantContext.Type variantType, GenotypeConcordanceCounts concordanceCounts, String truthSample, String callSample, boolean missingSitesFlag) {
        this.VARIANT_TYPE = variantType;
        this.TRUTH_SAMPLE = truthSample;
        this.CALL_SAMPLE = callSample;
        GenotypeConcordanceSchemeFactory schemeFactory = new GenotypeConcordanceSchemeFactory();
        GenotypeConcordanceScheme scheme = schemeFactory.getScheme(missingSitesFlag);
        scheme.validateScheme();
        concordanceCounts.validateCountsAgainstScheme(scheme);
        this.HET_SENSITIVITY = concordanceCounts.getSensitivity(scheme, GenotypeConcordanceCounts.HET_TRUTH_STATES);
        this.HET_PPV = concordanceCounts.Ppv(scheme, GenotypeConcordanceCounts.HET_CALL_STATES);
        this.HET_SPECIFICITY = Double.NaN;
        this.HOMVAR_SENSITIVITY = concordanceCounts.getSensitivity(scheme, GenotypeConcordanceCounts.HOM_VAR_TRUTH_STATES);
        this.HOMVAR_PPV = concordanceCounts.Ppv(scheme, GenotypeConcordanceCounts.HOM_VAR_CALL_STATES);
        this.HOMVAR_SPECIFICITY = Double.NaN;
        this.VAR_SENSITIVITY = concordanceCounts.getSensitivity(scheme, GenotypeConcordanceCounts.VAR_TRUTH_STATES);
        this.VAR_PPV = concordanceCounts.Ppv(scheme, GenotypeConcordanceCounts.VAR_CALL_STATES);
        this.VAR_SPECIFICITY = concordanceCounts.getSpecificity(scheme, GenotypeConcordanceCounts.VAR_TRUTH_STATES);
        this.GENOTYPE_CONCORDANCE = concordanceCounts.calculateGenotypeConcordance(scheme, missingSitesFlag);
        this.NON_REF_GENOTYPE_CONCORDANCE = concordanceCounts.calculateNonRefGenotypeConcordance(scheme, missingSitesFlag);
    }
}

