/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="This tool reads a VCF/VCF.gz/BCF and removes all genotype information from it while retainingall site level information, including annotations based on genotypes (e.g. AN, AF). Output can beany supported variant format including .vcf, .vcf.gz or .bcf. <br /><br /><h4>Usage example:</h4><pre>java -jar picard.jar MakeSitesOnlyVcf \\ <br />      INPUT=input_variants.vcf \\ <br />      OUTPUT=output_variants.vcf</pre>", oneLineSummary="Creates a VCF that contains all the site-level information for all records in the input VCF but no genotype information.", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public class MakeSitesOnlyVcf
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Creates a VCF that contains all the site-level information for all records in the input VCF but no genotype information.";
    static final String USAGE_DETAILS = "This tool reads a VCF/VCF.gz/BCF and removes all genotype information from it while retainingall site level information, including annotations based on genotypes (e.g. AN, AF). Output can beany supported variant format including .vcf, .vcf.gz or .bcf. <br /><br /><h4>Usage example:</h4><pre>java -jar picard.jar MakeSitesOnlyVcf \\ <br />      INPUT=input_variants.vcf \\ <br />      OUTPUT=output_variants.vcf</pre>";
    @Argument(shortName="I", doc="Input VCF or BCF containing genotype and site-level information.")
    public File INPUT;
    @Argument(shortName="O", doc="Output VCF or BCF file containing only site-level information.")
    public File OUTPUT;
    @Argument(shortName="S", doc="Names of one or more samples to include in the output VCF.", optional=true)
    public Set<String> SAMPLE = new TreeSet<String>();

    public MakeSitesOnlyVcf() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        VCFFileReader reader = new VCFFileReader(this.INPUT, false);
        VCFHeader inputVcfHeader = new VCFHeader(reader.getFileHeader().getMetaDataInInputOrder());
        SAMSequenceDictionary sequenceDictionary = inputVcfHeader.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        ProgressLogger progress = new ProgressLogger(Log.getInstance(MakeSitesOnlyVcf.class), 10000);
        VariantContextWriterBuilder builder = new VariantContextWriterBuilder().setOutputFile(this.OUTPUT).setReferenceDictionary(sequenceDictionary);
        if (this.CREATE_INDEX.booleanValue()) {
            builder.setOption(Options.INDEX_ON_THE_FLY);
        } else {
            builder.unsetOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter writer = builder.build();
        VCFHeader header = new VCFHeader(inputVcfHeader.getMetaDataInInputOrder(), this.SAMPLE);
        writer.writeHeader(header);
        Iterator iterator = reader.iterator();
        while (iterator.hasNext()) {
            VariantContext full = (VariantContext)iterator.next();
            VariantContext site = MakeSitesOnlyVcf.subsetToSamplesWithOriginalAnnotations(full, this.SAMPLE);
            writer.add(site);
            progress.record(site.getContig(), site.getStart());
        }
        CloserUtil.close(iterator);
        CloserUtil.close(reader);
        writer.close();
        return 0;
    }

    private static VariantContext subsetToSamplesWithOriginalAnnotations(VariantContext ctx, Set<String> samples) {
        VariantContextBuilder builder = new VariantContextBuilder(ctx);
        GenotypesContext newGenotypes = ctx.getGenotypes().subsetToSamples(samples);
        builder.alleles((Collection<Allele>)ctx.getAlleles());
        return builder.genotypes(newGenotypes).make();
    }
}

