/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl.smithwaterman;

import com.intel.gkl.IntelGKLUtils;
import com.intel.gkl.NativeLibraryLoader;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWAlignerNativeBinding;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWNativeAlignerResult;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWOverhangStrategy;
import org.broadinstitute.gatk.nativebindings.smithwaterman.SWParameters;

public class IntelSmithWaterman
implements SWAlignerNativeBinding {
    private static final Logger logger = LogManager.getLogger(IntelSmithWaterman.class);
    private static final String NATIVE_LIBRARY_NAME = "gkl_smithwaterman";
    private String nativeLibraryName = "gkl_smithwaterman";
    private static boolean initialized = false;
    private IntelGKLUtils gklUtils = new IntelGKLUtils();

    void setNativeLibraryName(String nativeLibraryName) {
        this.nativeLibraryName = nativeLibraryName;
    }

    public IntelSmithWaterman() {
        this.setNativeLibraryName(NATIVE_LIBRARY_NAME);
    }

    @Override
    public synchronized boolean load(File tempDir) {
        boolean isLoaded = this.gklUtils.load(null);
        if (!isLoaded) {
            logger.warn("Intel GKL Utils not loaded");
            return false;
        }
        if (!this.gklUtils.isAvxSupported() || !this.gklUtils.isAvx2Supported()) {
            return false;
        }
        if (!NativeLibraryLoader.load(tempDir, NATIVE_LIBRARY_NAME)) {
            return false;
        }
        if (!initialized) {
            initialized = true;
        }
        if (this.gklUtils.isAvx512Supported()) {
            logger.info("Using CPU-supported AVX-512 instructions");
        }
        IntelSmithWaterman.initNative();
        return true;
    }

    @Override
    public SWNativeAlignerResult align(byte[] refArray, byte[] altArray, SWParameters parameters, SWOverhangStrategy overhangStrategy) {
        int intStrategy = this.getStrategy(overhangStrategy);
        byte[] cigar = new byte[2 * Integer.max(refArray.length, altArray.length)];
        int offset = IntelSmithWaterman.alignNative(refArray, altArray, cigar, parameters.getMatchValue(), parameters.getMismatchPenalty(), parameters.getGapOpenPenalty(), parameters.getGapExtendPenalty(), intStrategy);
        return new SWNativeAlignerResult(new String(cigar).trim(), offset);
    }

    public int getStrategy(SWOverhangStrategy strategy) {
        int intStrategy = 0;
        switch (strategy) {
            case SOFTCLIP: {
                intStrategy = 9;
                break;
            }
            case INDEL: {
                intStrategy = 10;
                break;
            }
            case LEADING_INDEL: {
                intStrategy = 11;
                break;
            }
            case IGNORE: {
                intStrategy = 12;
            }
        }
        return intStrategy;
    }

    @Override
    public void close() {
        IntelSmithWaterman.doneNative();
    }

    private static native void initNative();

    private static native int alignNative(byte[] var0, byte[] var1, byte[] var2, int var3, int var4, int var5, int var6, int var7);

    private static native void doneNative();
}

