/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.common;

import java.util.Objects;

public class Version
implements Comparable<Version> {
    public final int major;
    public final int minor;
    private final int build;

    public Version(int major, int minor, int build) {
        this.major = major;
        this.minor = minor;
        this.build = build;
    }

    public Version(String version) {
        String[] numbers = version.split("[\\.\\-b]");
        this.major = Integer.valueOf(numbers[0]);
        this.minor = Integer.valueOf(numbers[1]);
        this.build = numbers.length > 3 ? Integer.valueOf(numbers[3]) : 0;
    }

    public String toString() {
        if (this.build > 0) {
            return String.format("%d.%d-b%d", this.major, this.minor, this.build);
        }
        return String.format("%d.%d", this.major, this.minor);
    }

    @Override
    public int compareTo(Version o) {
        if (o == null) {
            return -1;
        }
        if (this.major - o.major != 0) {
            return this.major - o.major;
        }
        if (this.minor - o.minor != 0) {
            return this.minor - o.minor;
        }
        if (this.build < 1 || o.build < 1) {
            return 0;
        }
        return this.build - o.build;
    }

    public boolean compatibleWith(Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.build == version.build;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.build);
    }
}

